/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class FuzzyStack {
    @Nonnull
    private final ItemStack stack;
    @Nonnull
    private final NBTTagCompound tags;
    private final boolean ignoreMeta;
    private final boolean useOreDict;
    @Nonnull
    private final List<String> ignoreTags;

    public FuzzyStack(ItemStack stack) {
        this(stack, false, false, new String[0]);
    }

    public FuzzyStack(ItemStack stack, boolean ignoreMeta, boolean useOreDict, String ... ignoreTags) {
        this(stack, ignoreMeta, useOreDict, Arrays.asList(ignoreTags));
    }

    public FuzzyStack(ItemStack stack, boolean ignoreMeta, boolean useOreDict, List<String> ignoreTags) {
        if (stack == null) {
            throw new NullPointerException("The Itemstack must not be null for FuzzyStacks!");
        }
        if (stack.func_77973_b() == null) {
            throw new NullPointerException("The Item must not be null for FuzzyStacks!");
        }
        this.stack = stack.func_77946_l();
        this.tags = Optional.ofNullable(stack.func_77978_p()).orElseGet(NBTTagCompound::new);
        this.ignoreTags = ignoreTags != null ? ignoreTags : Collections.EMPTY_LIST;
        this.ignoreMeta = ignoreMeta;
        this.useOreDict = useOreDict;
        this.stack.func_77982_d(this.stripTags(this.stack.func_77978_p()));
    }

    @Nonnull
    public static final Optional<FuzzyStack> fromBlockState(IBlockState state) {
        return Optional.ofNullable(state).map(s -> new ItemStack(s.func_177230_c(), 1, s.func_177230_c().func_176201_c(s))).filter(i -> i.func_77973_b() != null).map(FuzzyStack::new);
    }

    @Nonnull
    public ItemStack toStack() {
        ItemStack copy = this.stack.func_77946_l();
        copy.func_77982_d(this.tags.func_150296_c().isEmpty() ? null : this.tags.func_74737_b());
        return copy;
    }

    @Nonnull
    public Item getItem() {
        return this.stack.func_77973_b();
    }

    @Nonnull
    public int getMeta() {
        return this.stack.func_77960_j();
    }

    @Nonnull
    public NBTTagCompound getTagCompound() {
        return this.tags.func_74737_b();
    }

    public boolean isMetaEqual(ItemStack other) {
        return other != null && (this.ignoreMeta || this.getMeta() == other.func_77960_j());
    }

    public boolean isMetaEqual(FuzzyStack other) {
        return other != null && (this.ignoreMeta || other.ignoreMeta || this.getMeta() == other.getMeta());
    }

    public boolean isTagsEqual(ItemStack other) {
        return other != null && this.getTagCompound().equals((Object)this.stripTags(other.func_77978_p()));
    }

    public boolean isTagsEqual(FuzzyStack other) {
        return other != null && other.stripTags(this.getTagCompound()).equals((Object)this.stripTags(other.getTagCompound()));
    }

    public boolean isItemEqual(Item other) {
        return other != null && this.stack.func_77973_b().equals(other);
    }

    public boolean isItemEqual(ItemStack other) {
        return other != null && this.stack.func_77973_b().equals(other.func_77973_b());
    }

    public boolean isItemEqual(FuzzyStack other) {
        return other != null && this.stack.func_77973_b().equals(other.stack.func_77973_b());
    }

    @Nonnull
    private NBTTagCompound stripTags(NBTTagCompound tag) {
        if (tag == null || this.ignoreTags.contains("*")) {
            return new NBTTagCompound();
        }
        NBTTagCompound stripped = tag.func_74737_b();
        this.ignoreTags.forEach(arg_0 -> ((NBTTagCompound)stripped).func_82580_o(arg_0));
        return stripped;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack other = (ItemStack)obj;
            if (other.func_77973_b() != null) {
                return this.equals(new FuzzyStack(other));
            }
            return false;
        }
        if (obj instanceof FuzzyStack) {
            FuzzyStack other = (FuzzyStack)obj;
            if (this.isItemEqual(other) && this.isMetaEqual(other) && this.isTagsEqual(other)) {
                return true;
            }
            if (this.useOreDict || other.useOreDict) {
                int[] ids1 = OreDictionary.getOreIDs((ItemStack)this.toStack());
                int[] ids2 = OreDictionary.getOreIDs((ItemStack)other.toStack());
                for (int id1 : ids1) {
                    for (int id2 : ids2) {
                        if (id1 != id2) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.stack.toString();
    }
}

