/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.stat;

import com.infinityraider.agricraft.api.adapter.IAgriAdapterRegistry;
import com.infinityraider.agricraft.api.crop.IAgriCrop;
import com.infinityraider.agricraft.api.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.api.stat.IAgriStatCalculator;
import com.infinityraider.agricraft.apiimpl.StatCalculatorRegistry;
import java.util.List;
import java.util.Optional;

public interface IAgriStatCalculatorRegistry
extends IAgriAdapterRegistry<IAgriStatCalculator> {
    default public Optional<IAgriStat> calculateStats(IAgriPlant plant, List<? extends IAgriCrop> matureNeighbors) {
        return this.calculateStats(plant, matureNeighbors, false);
    }

    default public Optional<IAgriStat> calculateStats(IAgriMutation mutation, List<? extends IAgriCrop> matureNeighbors) {
        return this.calculateStats(mutation.getChild(), matureNeighbors, true);
    }

    default public Optional<IAgriStat> calculateStats(IAgriPlant child, List<? extends IAgriCrop> matureNeighbors, boolean mutation) {
        return StatCalculatorRegistry.getInstance().valueOf(child).map(calc -> calc.calculateStats(child, matureNeighbors, mutation));
    }
}

