/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.soil;

import com.infinityraider.agricraft.api.soil.IAgriSoil;
import com.infinityraider.agricraft.api.util.FuzzyStack;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public interface IAgriSoilRegistry {
    public boolean isSoil(IAgriSoil var1);

    public Optional<IAgriSoil> getSoil(String var1);

    default public Optional<IAgriSoil> getSoil(IBlockState state) {
        return FuzzyStack.fromBlockState(state).flatMap(this::getSoil);
    }

    default public Optional<IAgriSoil> getSoil(ItemStack stack) {
        return this.getSoil(new FuzzyStack(stack));
    }

    default public Optional<IAgriSoil> getSoil(FuzzyStack stack) {
        return this.getSoils().stream().filter(s -> s.isVarient(stack)).findFirst();
    }

    public boolean addSoil(IAgriSoil var1);

    public boolean removeSoil(IAgriSoil var1);

    public Collection<IAgriSoil> getSoils();

    public Set<String> getSoilIds();

    default public boolean isSoil(FuzzyStack soil) {
        return this.getSoils().stream().anyMatch(s -> s.isVarient(soil));
    }
}

