/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.seed;

import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.plant.IAgriPlantAcceptor;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.api.stat.IAgriStatAcceptor;
import java.util.Optional;

public interface IAgriSeedAcceptor
extends IAgriPlantAcceptor,
IAgriStatAcceptor {
    default public boolean acceptsSeed(AgriSeed seed) {
        return seed != null && this.acceptsPlant(seed.getPlant()) && this.acceptsStat(seed.getStat());
    }

    default public boolean setSeed(AgriSeed seed) {
        if (seed != null && this.acceptsSeed(seed)) {
            return this.setPlant(seed.getPlant()) && this.setStat(seed.getStat());
        }
        return false;
    }

    default public Optional<AgriSeed> removeSeed() {
        Optional<IAgriPlant> plant = this.removePlant();
        Optional<IAgriStat> stat = this.removeStat();
        if (plant.isPresent() && stat.isPresent()) {
            return Optional.of(new AgriSeed(plant.get(), stat.get()));
        }
        return Optional.empty();
    }
}

