/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.requirement;

import com.infinityraider.agricraft.api.requirement.BlockCondition;
import com.infinityraider.agricraft.api.requirement.ICondition;
import com.infinityraider.agricraft.api.soil.IAgriSoil;
import com.infinityraider.agricraft.api.util.FuzzyStack;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public interface IGrowthRequirement {
    default public boolean hasValidSoil(IBlockAccess world, BlockPos pos) {
        return FuzzyStack.fromBlockState(world.func_180495_p(pos.func_177977_b())).filter(soil -> this.getSoils().stream().anyMatch(e -> e.isVarient((FuzzyStack)soil))).isPresent();
    }

    default public boolean hasValidConditions(IBlockAccess world, BlockPos pos) {
        return this.getConditions().stream().sorted((a, b) -> Integer.compare(a.getComplexity(), b.getComplexity())).allMatch(c -> c.isMet(world, pos));
    }

    default public boolean hasValidLight(World world, BlockPos pos) {
        BlockPos above = pos.func_177984_a();
        int lvl = Math.max(world.func_175642_b(EnumSkyBlock.BLOCK, above), world.func_175642_b(EnumSkyBlock.SKY, above));
        return this.getMinLight() <= lvl && lvl < this.getMaxLight();
    }

    default public boolean isMet(World world, BlockPos pos) {
        return this.hasValidSoil((IBlockAccess)world, pos) && this.hasValidLight(world, pos) && this.hasValidConditions((IBlockAccess)world, pos);
    }

    public Collection<IAgriSoil> getSoils();

    public Collection<ICondition> getConditions();

    public int getMinLight();

    public int getMaxLight();

    default public Optional<FuzzyStack> getConditionStack() {
        return this.getConditions().stream().filter(c -> c instanceof BlockCondition).map(c -> ((BlockCondition)c).getStack()).findFirst();
    }
}

