/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.plant;

import com.infinityraider.agricraft.api.crop.IAdditionalCropData;
import com.infinityraider.agricraft.api.crop.IAgriCrop;
import com.infinityraider.agricraft.api.render.RenderMethod;
import com.infinityraider.agricraft.api.requirement.IGrowthRequirement;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.api.util.FuzzyStack;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IAgriPlant
extends Comparable<IAgriPlant> {
    public String getId();

    public String getPlantName();

    default public String getSeedName() {
        return this.getPlantName() + " Seeds";
    }

    public Collection<FuzzyStack> getSeedItems();

    default public boolean isWeed() {
        return false;
    }

    default public boolean isAggressive() {
        return false;
    }

    default public boolean isFertilizable() {
        return true;
    }

    default public double getSpreadChance() {
        return 0.5 / (double)this.getTier();
    }

    default public double getSpawnChance() {
        return 0.0;
    }

    default public double getGrowthChance() {
        return 0.1;
    }

    default public double getGrowthBonus() {
        return 0.025;
    }

    default public double getGrassDropChance() {
        return 0.0;
    }

    default public int getTier() {
        return 1;
    }

    default public int getGrowthStages() {
        return 8;
    }

    public String getInformation();

    public ItemStack getSeed();

    default public Block getBlock() {
        return null;
    }

    public IGrowthRequirement getGrowthRequirement();

    public List<ItemStack> getAllFruits();

    public ItemStack getRandomFruit(Random var1);

    default public void getFruitsOnHarvest(IAgriStat stats, Consumer<ItemStack> consumer, Random rand) {
        for (int amount = (stats.getGain() + 3) / 3; amount > 0; --amount) {
            consumer.accept(this.getRandomFruit(rand));
        }
    }

    default public void onHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    default public void onRemove(World world, BlockPos pos) {
    }

    default public void onPlanted(World world, BlockPos pos) {
    }

    default public void onValidate(World world, BlockPos pos, IAgriCrop crop) {
    }

    default public void onInvalidate(World world, BlockPos pos, IAgriCrop crop) {
    }

    default public void onChunkUnload(World world, BlockPos pos, IAgriCrop crop) {
    }

    default public void onAllowedGrowthTick(World world, BlockPos pos, IAgriCrop crop, int oldGrowthStage) {
    }

    default public IAdditionalCropData getInitialCropData(World world, BlockPos pos, IAgriCrop crop) {
        return null;
    }

    default public IAdditionalCropData readCropDataFromNBT(NBTTagCompound tag) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSeedTexture();

    public float getHeight(int var1);

    @SideOnly(value=Side.CLIENT)
    public RenderMethod getRenderMethod();

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getPrimaryPlantTexture(int var1);

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSecondaryPlantTexture(int var1);

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getPlantQuads(IExtendedBlockState var1, int var2, EnumFacing var3, Function<ResourceLocation, TextureAtlasSprite> var4);

    @Override
    default public int compareTo(IAgriPlant plant) {
        if (this.getTier() > plant.getTier()) {
            return 1;
        }
        return this.getId().compareTo(plant.getId());
    }
}

