/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.mutation;

import com.infinityraider.agricraft.api.plant.IAgriPlant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public interface IAgriMutation {
    public double getChance();

    @Nonnull
    public IAgriPlant getChild();

    @Nonnull
    public List<IAgriPlant> getParents();

    default public boolean hasChild(IAgriPlant plant) {
        return this.getChild().equals(plant);
    }

    default public boolean hasParent(IAgriPlant plant) {
        return this.getParents().contains(plant);
    }

    default public boolean hasParent(IAgriPlant ... plants) {
        return this.getParents().containsAll(Arrays.asList(plants));
    }

    default public boolean hasParent(Collection<IAgriPlant> plants) {
        return this.getParents().containsAll(plants);
    }

    default public boolean areParentsIn(IAgriPlant ... plants) {
        return Arrays.asList(plants).containsAll(this.getParents());
    }

    default public boolean areParentsIn(Collection<IAgriPlant> plants) {
        return plants.containsAll(this.getParents());
    }
}

