/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.crop;

import com.infinityraider.agricraft.api.crop.IAdditionalCropData;
import com.infinityraider.agricraft.api.fertilizer.IAgriFertilizable;
import com.infinityraider.agricraft.api.misc.IAgriHarvestable;
import com.infinityraider.agricraft.api.misc.IAgriWeedable;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.api.seed.IAgriSeedAcceptor;
import com.infinityraider.agricraft.api.seed.IAgriSeedProvider;
import com.infinityraider.agricraft.api.soil.IAgriSoil;
import java.util.List;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public interface IAgriCrop
extends IAgriSeedProvider,
IAgriSeedAcceptor,
IAgriWeedable,
IAgriFertilizable,
IAgriHarvestable {
    public BlockPos getPos();

    public int getGrowthStage();

    public void setGrowthStage(int var1);

    public boolean isCrossCrop();

    public void setCrossCrop(boolean var1);

    default public boolean isFertile() {
        return this.getSeed().filter(this::isFertile).isPresent();
    }

    default public boolean isFertile(AgriSeed seed) {
        return this.isFertile(seed.getPlant());
    }

    public boolean isFertile(IAgriPlant var1);

    public boolean isMature();

    default public boolean spawn() {
        return false;
    }

    default public boolean spread() {
        return false;
    }

    @Override
    default public boolean canWeed() {
        return this.getPlant().filter(p -> p.isWeed()).isPresent();
    }

    @Override
    default public boolean clearWeed() {
        if (this.canWeed()) {
            this.removePlant();
            return true;
        }
        return false;
    }

    public Optional<IAgriSoil> getSoil();

    public TileEntity getTileEntity();

    public IAdditionalCropData getAdditionalCropData();

    public List<IAgriCrop> getNeighbours();

    public List<IAgriCrop> getMatureNeighbours();
}

