/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.MathHelper;
import java.util.Arrays;
import java.util.List;

public class AgriStack {
    protected final String item;
    protected final int meta;
    protected final String tags;
    protected final boolean ignoreMeta;
    protected final List<String> ignoreTags;
    protected final boolean useOreDict;

    public AgriStack() {
        this("minecraft:dirt");
    }

    public AgriStack(String item) {
        this(item, 0, true);
    }

    public AgriStack(String item, int meta) {
        this(item, meta, false);
    }

    public AgriStack(String item, int meta, boolean ignoreMeta) {
        this(item, meta, ignoreMeta, false);
    }

    public AgriStack(String item, int meta, boolean ignoreMeta, boolean useOreDict) {
        this(item, meta, ignoreMeta, useOreDict, "", new String[0]);
    }

    public AgriStack(String item, int meta, boolean ignoreMeta, boolean useOreDict, String tags, String ... ignoreTags) {
        this(item, meta, ignoreMeta, useOreDict, tags, Arrays.asList(ignoreTags));
    }

    public AgriStack(String item, int meta, boolean ignoreMeta, boolean useOreDict, String tags, List<String> ignoreTags) {
        this.item = item;
        this.meta = meta;
        this.tags = tags;
        this.ignoreMeta = ignoreMeta;
        this.ignoreTags = ignoreTags;
        this.useOreDict = useOreDict;
    }

    public String getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public String getTags() {
        return this.tags;
    }

    public List<String> getIgnoreTags() {
        return this.ignoreTags;
    }

    public boolean isIgnoreMeta() {
        return this.ignoreMeta;
    }

    public boolean isUseOreDict() {
        return this.useOreDict;
    }

    public Object toStack() {
        return this.toStack(1);
    }

    public Object toStack(int amount) {
        return AgriCore.getConverter().toStack(this.item, this.meta, amount, this.tags, this.ignoreMeta, this.useOreDict, this.ignoreTags);
    }

    public boolean validate() {
        return AgriCore.getValidator().isValidItem(this.item);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStack:");
        sb.append("\n\t- Item: ").append(this.item);
        sb.append("\n\t- Meta: ").append(this.meta);
        sb.append("\n\t- Tags: ").append(this.tags);
        sb.append("\n\t- IgnoreMeta: ").append(this.ignoreMeta);
        sb.append("\n\t- IgnoreTags: ").append(this.ignoreTags);
        sb.append("\n\t- UseOreDict: ").append(this.useOreDict);
        return sb.toString();
    }

    public static final AgriStack fromString(String s) {
        String[] parts = s.split(":");
        switch (parts.length) {
            case 3: {
                return new AgriStack(parts[0] + ":" + parts[1], MathHelper.parseIntOr(parts[2], 0));
            }
        }
        return new AgriStack(s);
    }
}

