/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriSerializable;
import com.agricraft.agricore.plant.AgriStack;
import com.agricraft.agricore.util.TypeHelper;
import java.util.List;
import java.util.stream.Collectors;

public class AgriSoil
implements AgriSerializable {
    private String path;
    private final boolean enabled;
    private final String id;
    private final String name;
    private final List<AgriStack> varients;

    public AgriSoil() {
        this.enabled = true;
        this.id = "dirt_soil";
        this.name = "Dirt";
        this.varients = TypeHelper.asList(new AgriStack());
    }

    public AgriSoil(String id, String name, List<AgriStack> varients) {
        this.enabled = true;
        this.id = id;
        this.name = name;
        this.varients = varients;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getVarients() {
        return this.varients.stream().map(t -> t.toStack()).filter(TypeHelper::isNonNull).collect(Collectors.toList());
    }

    public boolean validate() {
        this.varients.removeIf(block -> {
            if (!block.validate()) {
                AgriCore.getCoreLogger().info("Invalid Soil Varient: {0}\nRemoving!", block);
                return true;
            }
            return false;
        });
        return !this.varients.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nSoil:\n");
        sb.append("\t- Id: ").append(this.id).append("\n");
        sb.append("\t- Name: ").append(this.name).append("\n");
        this.varients.forEach(e -> sb.append("\t- Block: ").append(e).append("\n"));
        return sb.toString();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }
}

