/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriSoil;
import com.agricraft.agricore.plant.AgriStack;
import com.agricraft.agricore.util.TypeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AgriRequirement {
    private final int min_light;
    private final int max_light;
    private final List<String> soils;
    private final List<String> bases;
    private final Map<String, Integer> nearby;

    public AgriRequirement() {
        this.min_light = 10;
        this.max_light = 16;
        this.soils = new ArrayList<String>();
        this.bases = new ArrayList<String>();
        this.nearby = new HashMap<String, Integer>();
    }

    public AgriRequirement(List<String> soils, List<String> bases, Map<String, Integer> nearby, int min_light, int max_light) {
        this.soils = new ArrayList<String>(soils);
        this.bases = bases;
        this.nearby = nearby;
        this.min_light = 10;
        this.max_light = 16;
    }

    public int getMinLight() {
        return this.min_light;
    }

    public int getMaxLight() {
        return this.max_light;
    }

    public List<AgriSoil> getSoils() {
        return this.soils.stream().map(AgriCore.getSoils()::getSoil).filter(TypeHelper::isNonNull).collect(Collectors.toList());
    }

    public List<Object> getBases() {
        return this.bases.stream().map(AgriStack::fromString).map(AgriStack::toStack).filter(TypeHelper::isNonNull).collect(Collectors.toList());
    }

    public Map<Object, Integer> getNearby() {
        HashMap<Object, Integer> res = new HashMap<Object, Integer>();
        this.nearby.forEach((block, dist) -> {
            Object stack = AgriStack.fromString(block).toStack();
            if (stack != null) {
                res.put(stack, (Integer)dist);
            }
        });
        return res;
    }

    public boolean validate() {
        this.soils.removeIf(soil -> {
            if (!AgriCore.getSoils().hasSoil((String)soil)) {
                AgriCore.getCoreLogger().info("Invalid Requirement: Invalid Soil: {0}! Removing!", soil);
                return true;
            }
            return false;
        });
        for (String block : this.bases) {
            if (AgriCore.getValidator().isValidBlock(block)) continue;
            AgriCore.getCoreLogger().info("Invalid Requirement: Invalid Base: {0}!", block);
            return false;
        }
        for (String block : this.nearby.keySet()) {
            if (AgriCore.getValidator().isValidBlock(block)) continue;
            AgriCore.getCoreLogger().info("Invalid Requirement: Invalid Nearby: {0}!", block);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nRequirement:\n");
        sb.append("\t- Light:\n");
        sb.append("\t\t- Min: ").append(this.min_light).append("\n");
        sb.append("\t\t- Max: ").append(this.max_light).append("\n");
        sb.append("\t- Soil:\n");
        this.soils.forEach(e -> sb.append("\t\t- AgriSoil: ").append((String)e).append("\n"));
        sb.append("\t- Base:\n");
        this.bases.forEach(e -> sb.append("\t\t- Block: ").append((String)e).append("\n"));
        sb.append("\t- Nearby:\n");
        this.nearby.entrySet().forEach(e -> {
            sb.append("\t\t- Block: ").append((String)e.getKey()).append("\n\t");
            sb.append("\t\t- Distance: ").append(e.getValue()).append("\n");
        });
        return sb.toString();
    }
}

