/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriProduct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class AgriProductList {
    private final List<AgriProduct> products;

    public AgriProductList() {
        this.products = new ArrayList<AgriProduct>();
        this.products.add(new AgriProduct());
    }

    public AgriProductList(List<AgriProduct> products) {
        this.products = products;
    }

    public final List<AgriProduct> getAll() {
        return new ArrayList<AgriProduct>(this.products);
    }

    public final List<AgriProduct> getRandom(Random rand) {
        ArrayList<AgriProduct> produce = new ArrayList<AgriProduct>();
        this.products.forEach(product -> {
            if (product.shouldDrop(rand)) {
                produce.add((AgriProduct)product);
            }
        });
        return produce;
    }

    public boolean validate() {
        Iterator<AgriProduct> iter = this.products.iterator();
        while (iter.hasNext()) {
            AgriProduct product = iter.next();
            if (product.validate()) continue;
            if (product.isRequired()) {
                AgriCore.getCoreLogger().info("Invalid List: Invalid Required Product!", new Object[0]);
                return false;
            }
            AgriCore.getCoreLogger().info("Product List: Removing Invalid Non-Required Product!", new Object[0]);
            iter.remove();
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nProduct List:\n");
        sb.append("\t- Products: ");
        this.products.forEach(e -> sb.append("\n\t\t- ").append(e.toString().replaceAll("\n", "\n\t\t").trim()));
        return sb.toString();
    }
}

