/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.json;

import com.agricraft.agricore.config.AgriConfigCategory;
import com.agricraft.agricore.config.AgriConfigurable;
import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriFileWalker;
import com.agricraft.agricore.json.AgriSaver;
import com.agricraft.agricore.json.AgriSerializable;
import com.agricraft.agricore.registry.AgriLoadableRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class AgriLoader {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @AgriConfigurable(key="Enable JSON Writeback", category=AgriConfigCategory.CORE, comment="Set to false to disable automatic JSON writeback.")
    public static boolean writeback = true;

    private AgriLoader() {
    }

    public static void loadDirectory(Path dir, AgriLoadableRegistry ... registries) {
        try {
            Files.walkFileTree(dir, new AgriFileWalker(dir, registries));
        }
        catch (IOException e) {
            AgriCore.getCoreLogger().debug("Unable to load directory: \"{0}\"!", dir);
        }
    }

    protected static <T extends AgriSerializable> void loadElement(Path root, Path location, AgriLoadableRegistry<T> registry) {
        AgriSerializable obj;
        if (!Files.exists(location, new LinkOption[0])) {
            AgriCore.getCoreLogger().warn("Tried to load non-existant File: \"{0}\"!", location);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(location);){
            obj = (AgriSerializable)GSON.fromJson((Reader)reader, registry.getElementClass());
            obj.setPath(root.relativize(location).toString().replaceAll("\\\\", "/"));
        }
        catch (JsonParseException | IOException e) {
            AgriCore.getCoreLogger().warn("Unable to load Element: \"{0}\"!", location);
            AgriCore.getCoreLogger().trace((Exception)e);
            return;
        }
        if (writeback) {
            AgriSaver.saveElement(location, obj);
        }
        registry.registerElement(obj);
    }

    static {
        AgriCore.getConfig().addConfigurable(AgriLoader.class);
    }
}

