/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.json;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriLoader;
import com.agricraft.agricore.registry.AgriLoadableRegistry;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;

public class AgriFileWalker
extends SimpleFileVisitor<Path> {
    public static final String MOD_PREFIX = "mod_";
    private final AgriLoadableRegistry[] registries;
    private final Path root;

    public AgriFileWalker(Path root, AgriLoadableRegistry ... registries) {
        this.root = Objects.requireNonNull(root);
        this.registries = Objects.requireNonNull(registries);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Objects.requireNonNull(dir);
        Objects.requireNonNull(attrs);
        String loc = this.root.relativize(dir).toString();
        String dirname = dir.getFileName().toString();
        if (!dirname.startsWith(MOD_PREFIX)) {
            if (!loc.isEmpty() && !loc.contains("\\")) {
                AgriCore.getCoreLogger().debug("Loading: \"json:{0}\"!", loc);
            }
            return FileVisitResult.CONTINUE;
        }
        String modid = dirname.substring(4);
        if (AgriCore.getValidator().isValidMod(modid)) {
            AgriCore.getCoreLogger().debug("Loading: \"json:{0}\" for mod: \"{1}\"!", loc, modid);
            return FileVisitResult.CONTINUE;
        }
        AgriCore.getCoreLogger().debug("Skipping: \"json:{0}\" for missing mod: \"{1}\"!", loc, modid);
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Objects.requireNonNull(file);
        Objects.requireNonNull(attrs);
        for (AgriLoadableRegistry r : this.registries) {
            if (!r.acceptsElement(file.getFileName().toString())) continue;
            AgriLoader.loadElement(this.root, file, r);
        }
        return FileVisitResult.CONTINUE;
    }
}

