/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Cuboid6;
import cofh.core.render.IModelRegister;
import cofh.core.render.hitbox.CustomHitBox;
import cofh.core.render.hitbox.RenderHitbox;
import cofh.core.util.core.IInitializer;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemAttachment
extends Item
implements IInitializer,
IModelRegister {
    public ItemAttachment() {
        this.func_77627_a(true);
        this.func_77637_a(ThermalDynamics.tabCommon);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Attachment attachment = this.getAttachment(stack, player, world, pos, facing);
        if (attachment != null && attachment.addToTile()) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public Attachment getAttachment(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        Attachment attachment = null;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGrid) {
            int subHit;
            int s = -1;
            RayTraceResult movingObjectPosition = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
            if (movingObjectPosition != null && (s = (subHit = movingObjectPosition.subHit) < 6 ? subHit : (subHit < 12 ? subHit - 6 : (subHit == 13 ? side.ordinal() : (subHit - 14) % 6))) != -1) {
                attachment = this.getAttachment(EnumFacing.field_82609_l[s ^ 1], stack, (TileGrid)tile);
            }
        } else {
            tile = BlockHelper.getAdjacentTileEntity((World)world, (BlockPos)pos, (EnumFacing)side);
            if (tile instanceof TileGrid) {
                attachment = this.getAttachment(side, stack, (TileGrid)tile);
            }
        }
        return attachment;
    }

    public abstract Attachment getAttachment(EnumFacing var1, ItemStack var2, TileGrid var3);

    public boolean initialize() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        return true;
    }

    public boolean postInit() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        RayTraceResult target = event.getTarget();
        if (target.field_72313_a != RayTraceResult.Type.BLOCK || !ItemUtils.isPlayerHoldingSomething((EntityPlayer)event.getPlayer()) || ItemUtils.getHeldStack((EntityPlayer)event.getPlayer()).func_77973_b() != this) {
            return;
        }
        RayTracer.retraceBlock((World)event.getPlayer().field_70170_p, (EntityPlayer)event.getPlayer(), (BlockPos)target.func_178782_a());
        ItemStack stack = ItemUtils.getHeldStack((EntityPlayer)event.getPlayer());
        Attachment attachment = this.getAttachment(stack, event.getPlayer(), event.getPlayer().func_130014_f_(), target.func_178782_a(), target.field_178784_b);
        if (attachment == null || !attachment.canAddToTile(attachment.baseTile)) {
            return;
        }
        Cuboid6 c = attachment.getCuboid();
        c.max.subtract(c.min);
        RenderHitbox.drawSelectionBox((EntityPlayer)event.getPlayer(), (RayTraceResult)target, (float)event.getPartialTicks(), (CustomHitBox)new CustomHitBox(c.max.y, c.max.z, c.max.x, (double)attachment.baseTile.x() + c.min.x, (double)attachment.baseTile.y() + c.min.y, (double)attachment.baseTile.z() + c.min.z));
        attachment.drawSelectionExtra(event.getPlayer(), target, event.getPartialTicks());
        event.setCanceled(true);
    }
}

