/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.core.gui.GuiCore;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButtonManaged;
import cofh.lib.gui.element.listbox.SliderVertical;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.entity.DuctUnitTransport;
import cofh.thermaldynamics.gui.client.DirectoryEntry;
import cofh.thermaldynamics.gui.container.ContainerTransport;
import cofh.thermaldynamics.gui.element.ElementDirectoryButton;
import java.util.ArrayList;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiTransport
extends GuiCore {
    final ContainerTransport container;
    public static final String TEX_PATH = "thermaldynamics:textures/gui/transport.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermaldynamics:textures/gui/transport.png");
    ElementDirectoryButton[] directoryButtons;
    SliderVertical vertical;
    public ElementButtonManaged buttonConfig;
    public int x0;
    public int y0;
    public static final int NUM_ENTRIES = 7;
    public static final int BUTTON_WIDTH = 155;
    public static final int BUTTON_HEIGHT = 22;
    public static final int BUTTON_OFFSET = 1;
    public static final int GUI_BUTTON_X0_BASE = 0;
    public static final int GUI_BUTTON_Y0_BASE = 204;
    public static final int GUI_BUTTON_X0_HOVER = 0;
    public static final int GUI_BUTTON_Y0_HOVER = 226;
    static final int SLIDER_WIDTH = 6;

    public GuiTransport(ContainerTransport container) {
        super((Container)container, TEXTURE);
        this.container = container;
        this.field_147000_g = 204;
        this.drawInventory = false;
        this.drawTitle = true;
        this.name = "gui.thermaldynamics.transport.name";
    }

    public GuiTransport(DuctUnitTransport transportDuct) {
        this(new ContainerTransport(transportDuct));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.x0 = (this.field_146999_f - 155) / 2 - 6;
        this.y0 = this.getFontRenderer().field_78288_b + 28;
        this.vertical = new SliderVertical((GuiBase)this, this.field_146999_f - 6 - 6, this.y0, 6, 160, 10);
        this.vertical.setVisible(false);
        this.addElement((ElementBase)this.vertical);
        this.directoryButtons = new ElementDirectoryButton[7];
        for (int i = 0; i < 7; ++i) {
            this.directoryButtons[i] = new ElementDirectoryButton(i, this, this.x0, this.y0);
            this.addElement((ElementBase)this.directoryButtons[i]);
        }
        Mouse.setCursorPosition((int)((this.directoryButtons[0].getPosX() + (this.directoryButtons[0].getWidth() >> 1) + this.field_147003_i) * this.field_146297_k.field_71443_c / this.field_146294_l), (int)((this.field_146295_m - (1 + this.directoryButtons[0].getPosY() + (this.directoryButtons[0].getHeight() >> 1) + this.field_147009_r + 1)) * this.field_146297_k.field_71440_d / this.field_146295_m));
        String configText = StringHelper.localize((String)"gui.thermaldynamics.transport.config");
        int stringWidth = this.getFontRenderer().func_78256_a(configText);
        this.buttonConfig = new ElementButtonManaged((GuiBase)this, this.field_146999_f - 12 - stringWidth, 16, stringWidth + 8, 16, configText){

            public void onClick() {
                PacketTileInfo myPayload = GuiTransport.this.container.transportDuct.newPacketTileInfo();
                myPayload.addByte(3);
                PacketHandler.sendToServer((PacketBase)myPayload);
            }
        };
        this.addElement((ElementBase)this.buttonConfig);
    }

    protected void func_146979_b(int x, int y) {
        ArrayList<DirectoryEntry> directory;
        super.func_146979_b(x, y);
        DirectoryEntry directoryEntry = this.container.directoryEntry;
        if (directoryEntry != null) {
            int dy = 15;
            int by = directoryEntry.icon != null ? 22 : 0;
            String text = this.getFontRenderer().func_78269_a(directoryEntry.getName(), this.field_146999_f - this.buttonConfig.getWidth() - 16 - by);
            this.getFontRenderer().func_78276_b(text, this.x0 + by + 4, dy + 7, 0x404040);
            if (directoryEntry.icon != null) {
                this.drawItemStack(directoryEntry.icon, this.x0 + 3, dy + 3, false, null);
            }
        }
        if ((directory = this.container.directory) == null) {
            this.field_146289_q.func_78276_b(StringHelper.localize((String)"gui.thermaldynamics.transport.waiting"), this.getCenteredOffset(StringHelper.localize((String)"gui.thermaldynamics.transport.waiting")), this.field_147000_g / 2, 0x404040);
        } else if (directory.isEmpty()) {
            this.field_146289_q.func_78276_b(StringHelper.localize((String)"gui.thermaldynamics.transport.noDest"), this.getCenteredOffset(StringHelper.localize((String)"gui.thermaldynamics.transport.noDest")), this.field_147000_g / 2, 0x404040);
        }
    }

    public void goToDest(DirectoryEntry directoryEntry) {
        this.container.transportDuct.sendRequest(directoryEntry.x, directoryEntry.y, directoryEntry.z);
    }

    protected void updateElementInformation() {
        ArrayList<DirectoryEntry> directory = this.container.directory;
        if (directory == null) {
            return;
        }
        boolean needSlider = directory.size() > 7;
        int additionalEntries = directory.size() - 7;
        this.vertical.setVisible(needSlider);
        this.vertical.setLimits(0, needSlider ? additionalEntries : 0);
        this.x0 = (this.field_146999_f - 155) / 2 - (needSlider ? 6 : 0);
        int offset = this.vertical.getValue();
        for (int i = 0; i < this.directoryButtons.length; ++i) {
            int index = offset + i;
            this.directoryButtons[i].setPosX(this.x0);
            this.directoryButtons[i].setEntry(index >= directory.size() ? null : directory.get(index));
        }
    }

    protected boolean onMouseWheel(int mouseX, int mouseY, int wheelMovement) {
        return this.vertical.isVisible() && this.vertical.onMouseWheel(mouseX, mouseY, wheelMovement);
    }
}

