/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.light;

import cofh.core.network.PacketCoFHBase;
import cofh.thermaldynamics.duct.light.DuctUnitLight;
import cofh.thermaldynamics.duct.light.GridLight;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.multiblock.IGridTile;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketLight
extends PacketCoFHBase {
    public ByteArrayInputStream stream;

    public PacketLight() {
    }

    public PacketLight(boolean lit, GridLight grid) {
        this.addBool(lit);
        this.addVarInt(grid.idleSet.size() + grid.nodeSet.size());
        for (IGridTile iGridTile : Iterables.concat((Iterable)grid.nodeSet, (Iterable)grid.idleSet)) {
            this.addVarInt(iGridTile.x());
            this.addVarInt(iGridTile.y());
            this.addVarInt(iGridTile.z());
        }
    }

    public void handlePacket(EntityPlayer player, boolean isServer) {
        boolean lit = this.getBool();
        int n = this.getVarInt();
        World world = player.field_70170_p;
        for (int i = 0; i < n; ++i) {
            DuctUnitLight lamp;
            TileEntity tile;
            int z;
            int y;
            int x = this.getVarInt();
            BlockPos pos = new BlockPos(x, y = this.getVarInt(), z = this.getVarInt());
            if (!world.func_175667_e(pos) || !((tile = world.func_175625_s(pos)) instanceof IDuctHolder) || (lamp = ((IDuctHolder)tile).getDuct(DuctToken.LIGHT)) == null) continue;
            lamp.lit = lit;
            lamp.checkLight();
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.stream = new ByteArrayInputStream(buffer.array());
        this.datain = new DataInputStream(this.stream);
        try {
            this.datain.skipBytes(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

