/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.lib.util.helpers.FluidHelper;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GridFluidSuper
extends GridFluid {
    int nodeTracker;
    boolean isSendingFluid;
    DuctUnitFluid[] nodeList = null;

    public GridFluidSuper(World world) {
        super(world);
    }

    @Override
    public void tickGrid() {
        super.tickGrid();
        int i = 0;
        if (this.nodeList == null) {
            this.nodeList = new DuctUnitFluid[this.nodeSet.size()];
            for (IGridTile multiBlock : this.nodeSet) {
                this.nodeList[i] = (DuctUnitFluid)multiBlock;
                ++i;
            }
        }
    }

    public int sendFluid(FluidStack fluid, boolean simulate) {
        int i;
        if (fluid == null || !FluidHelper.isFluidEqualOrNull((FluidStack)this.myTank.getFluid(), (FluidStack)fluid) || this.isSendingFluid) {
            return 0;
        }
        int fluidToSend = fluid.amount;
        int addedToGrid = this.myTank.fill(fluid, !simulate);
        if ((fluidToSend -= addedToGrid) <= 0) {
            return fluid.amount;
        }
        int tempTracker = this.nodeTracker;
        DuctUnitFluid[] list = this.nodeList;
        if (list == null || list.length == 0) {
            return fluid.amount - fluidToSend;
        }
        this.isSendingFluid = true;
        for (i = this.nodeTracker; i < list.length && fluidToSend > 0; ++i) {
            if ((fluidToSend -= this.trackInOut(list[i].transfer(fluidToSend, simulate, fluid, false), simulate)) != 0) continue;
            this.nodeTracker = i + 1;
        }
        for (i = 0; i < list.length && i < this.nodeTracker && fluidToSend > 0; ++i) {
            if ((fluidToSend -= this.trackInOut(list[i].transfer(fluidToSend, simulate, fluid, false), simulate)) != 0) continue;
            this.nodeTracker = i + 1;
        }
        if (fluidToSend > 0) {
            ++this.nodeTracker;
        }
        if (this.nodeTracker >= list.length) {
            this.nodeTracker = 0;
        }
        if (simulate) {
            this.nodeTracker = tempTracker;
        }
        this.isSendingFluid = false;
        return fluid.amount - fluidToSend;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.nodeList = null;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid grid) {
        return grid instanceof GridFluidSuper;
    }

    @Override
    public void destroy() {
        this.nodeList = null;
        super.destroy();
    }
}

