/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.core.fluid.FluidTankCore;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankGrid
extends FluidTankCore {
    public int fluidThroughput = 120;
    public int fluidPerDuct = 3000;
    public GridFluid myMaster;
    static TObjectIntHashMap<String> fluidFlowrate = new TObjectIntHashMap();

    public FluidTankGrid(int capacity, GridFluid theGrid) {
        super(capacity);
        this.myMaster = theGrid;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != null) {
            this.setFluidData(fluid);
        }
        super.setFluid(fluid);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.fluid == null && resource != null) {
            this.setFluidData(resource);
        }
        return this.myMaster.trackIn(super.fill(resource, doFill), !doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drain = super.drain(maxDrain, doDrain);
        if (doDrain && drain != null) {
            this.myMaster.trackOut(drain.amount, false);
        }
        return drain;
    }

    public void setFluidData(FluidStack fluid) {
        if (fluid != null) {
            int viscosity = Math.max(fluid.getFluid().getViscosity(), 100);
            this.fluidThroughput = MathHelper.clamp((int)(120000 / viscosity), (int)80, (int)600);
            if (fluidFlowrate.containsKey((Object)fluid.getFluid().getName())) {
                this.fluidThroughput = fluidFlowrate.get((Object)fluid.getFluid().getName());
            }
            this.fluidThroughput = (int)((float)this.fluidThroughput * this.myMaster.getThroughPutModifier());
            this.fluidPerDuct = Math.min(25 * this.fluidThroughput, this.myMaster.getMaxFluidPerDuct());
        }
        this.myMaster.fluidChanged();
    }

    static {
        fluidFlowrate.put((Object)"steam", 600);
    }
}

