/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.energy.GridEnergy;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.duct.tiles.TileDuctEnergy;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class DuctUnitEnergy
extends DuctUnit<DuctUnitEnergy, GridEnergy, IEnergyReceiver>
implements cofh.api.energy.IEnergyStorage {
    public int energyForGrid = 0;
    public int lastStoredValue = 0;
    byte internalSideCounter;
    private int transferLimit;
    private int capacity;

    public DuctUnitEnergy(TileGrid parent, Duct duct, int transferLimit, int capacity) {
        super(parent, duct);
        this.transferLimit = transferLimit;
        this.capacity = capacity;
    }

    public DuctUnitEnergy(TileDuctEnergy parent, Duct duct) {
        super(parent, duct);
        this.transferLimit = GridEnergy.NODE_TRANSFER[duct.type];
        this.capacity = GridEnergy.NODE_STORAGE[duct.type];
    }

    protected IEnergyReceiver[] createTileCache() {
        return new Cache[6];
    }

    protected DuctUnitEnergy[] createDuctCache() {
        return new DuctUnitEnergy[6];
    }

    @Override
    @Nonnull
    public DuctToken<DuctUnitEnergy, GridEnergy, IEnergyReceiver> getToken() {
        return DuctToken.ENERGY;
    }

    @Override
    public GridEnergy createGrid() {
        return new GridEnergy(this.world(), this.getTransferLimit(), this.getCapacity());
    }

    @Override
    protected void handleTileSideUpdate(@Nullable TileEntity tile, @Nullable IDuctHolder holder, byte side, @Nonnull ConnectionType type, byte oppositeSide) {
        DuctUnitEnergy adjDuct;
        this.nodeMask = (byte)(this.nodeMask & ~(1 << side));
        this.inputMask = (byte)(this.inputMask & ~(1 << side));
        this.setSideToNone(side);
        if (tile == null || !type.allowEnergy) {
            if (this.isInputTile(tile, side)) {
                this.inputMask = (byte)(this.inputMask | 1 << side);
                this.nodeMask = (byte)(this.nodeMask | 1 << side);
            }
            return;
        }
        if (holder != null && !holder.isSideBlocked(oppositeSide) && (adjDuct = holder.getDuct(this.getToken())) != null && this.canConnectToOtherDuct(adjDuct, side, oppositeSide) && ((DuctUnit)adjDuct).canConnectToOtherDuct(this, oppositeSide, side)) {
            ((DuctUnitEnergy[])this.ductCache)[side] = (DuctUnitEnergy)adjDuct.cast();
            return;
        }
        this.loadSignificantCache(tile, side);
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitEnergy, GridEnergy, IEnergyReceiver> adjDuct, byte side, byte oppositeSide) {
        return this.getTransferLimit() == adjDuct.cast().getTransferLimit();
    }

    @Override
    @Nullable
    public Cache cacheTile(final @Nonnull TileEntity tile, byte side) {
        IEnergyStorage capability;
        EnumFacing facing = EnumFacing.values()[side ^ 1];
        if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver receiver = (IEnergyReceiver)tile;
            if (receiver.canConnectEnergy(facing) || tile instanceof IDuctHolder) {
                return new Cache(receiver);
            }
        } else if (tile instanceof IEnergyProvider) {
            IEnergyProvider provider = (IEnergyProvider)tile;
            if (provider.canConnectEnergy(facing) || tile instanceof IDuctHolder) {
                return new Cache(provider);
            }
        } else if (tile.hasCapability(CapabilityEnergy.ENERGY, facing) && (capability = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing)) != null) {
            if (capability.canReceive()) {
                IEnergyReceiver capReceiver = new IEnergyReceiver(){

                    public IEnergyStorage getStorage(EnumFacing facing1) {
                        if (tile.hasCapability(CapabilityEnergy.ENERGY, facing1)) {
                            return (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing1);
                        }
                        return null;
                    }

                    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
                        IEnergyStorage storage = this.getStorage(from);
                        return storage == null ? 0 : storage.receiveEnergy(maxReceive, simulate);
                    }

                    public int getEnergyStored(EnumFacing from) {
                        IEnergyStorage storage = this.getStorage(from);
                        return storage == null ? 0 : storage.getEnergyStored();
                    }

                    public int getMaxEnergyStored(EnumFacing from) {
                        IEnergyStorage storage = this.getStorage(from);
                        return storage == null ? 0 : storage.getMaxEnergyStored();
                    }

                    public boolean canConnectEnergy(EnumFacing from) {
                        return true;
                    }
                };
                return new Cache(capReceiver);
            }
            IEnergyProvider capProvider = new IEnergyProvider(){

                public IEnergyStorage getStorage(EnumFacing facing1) {
                    if (tile.hasCapability(CapabilityEnergy.ENERGY, facing1)) {
                        return (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing1);
                    }
                    return null;
                }

                public int extractEnergy(EnumFacing from, int maxReceive, boolean simulate) {
                    IEnergyStorage storage = this.getStorage(from);
                    return storage == null ? 0 : storage.extractEnergy(maxReceive, simulate);
                }

                public int getEnergyStored(EnumFacing from) {
                    IEnergyStorage storage = this.getStorage(from);
                    return storage == null ? 0 : storage.getEnergyStored();
                }

                public int getMaxEnergyStored(EnumFacing from) {
                    IEnergyStorage storage = this.getStorage(from);
                    return storage == null ? 0 : storage.getMaxEnergyStored();
                }

                public boolean canConnectEnergy(EnumFacing from) {
                    return true;
                }
            };
            return new Cache(capProvider);
        }
        return null;
    }

    @Override
    public boolean tickPass(int pass) {
        return super.tickPass(pass) && this.sendEnergy();
    }

    public boolean sendEnergy() {
        int power = ((GridEnergy)this.grid).getSendableEnergy();
        int usedPower = this.transmitEnergy(power, false);
        ((GridEnergy)this.grid).useEnergy(usedPower);
        return true;
    }

    public int getEnergyForGrid() {
        return this.energyForGrid;
    }

    public void setEnergyForGrid(int energy) {
        this.energyForGrid = energy;
    }

    public int transmitEnergy(int energy, boolean simulate) {
        IEnergyReceiver receiver;
        byte i;
        int usedEnergy = 0;
        for (i = this.internalSideCounter; i < 6 && usedEnergy < energy; i = (byte)(i + 1)) {
            if (((IEnergyReceiver[])this.tileCache)[i] == null) continue;
            receiver = ((IEnergyReceiver[])this.tileCache)[i];
            if (receiver.canConnectEnergy(EnumFacing.field_82609_l[i ^ 1])) {
                usedEnergy += this.sendEnergy(receiver, energy - usedEnergy, i, simulate);
            }
            if (simulate || usedEnergy < energy) continue;
            this.internalSideCounter = this.tickInternalSideCounter(i + 1);
            break;
        }
        for (i = 0; i < this.internalSideCounter && usedEnergy < energy; i = (byte)(i + 1)) {
            if (((IEnergyReceiver[])this.tileCache)[i] == null) continue;
            receiver = ((IEnergyReceiver[])this.tileCache)[i];
            if (receiver.canConnectEnergy(EnumFacing.field_82609_l[i ^ 1])) {
                usedEnergy += this.sendEnergy(receiver, energy - usedEnergy, i, simulate);
            }
            if (simulate || usedEnergy < energy) continue;
            this.internalSideCounter = this.tickInternalSideCounter(i + 1);
            break;
        }
        return usedEnergy;
    }

    public int getTransferLimit() {
        return this.transferLimit;
    }

    public int getCapacity() {
        return this.capacity;
    }

    protected int sendEnergy(IEnergyReceiver receiver, int maxReceive, byte side, boolean simulate) {
        return receiver.receiveEnergy(EnumFacing.field_82609_l[side ^ 1], maxReceive, simulate);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.energyForGrid = nbt.func_74762_e("Energy");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.grid != null) {
            if (this.isNode()) {
                this.lastStoredValue = ((GridEnergy)this.grid).getNodeShare(this);
                nbt.func_74768_a("Energy", this.lastStoredValue);
            }
        } else if (this.energyForGrid > 0) {
            nbt.func_74768_a("Energy", this.energyForGrid);
        } else {
            this.energyForGrid = 0;
        }
        return nbt;
    }

    public boolean canExtract() {
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.grid != null ? ((GridEnergy)this.grid).receiveEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.grid != null ? ((GridEnergy)this.grid).myStorage.getEnergyStored() : 0;
    }

    public int getMaxEnergyStored() {
        return this.grid != null ? ((GridEnergy)this.grid).myStorage.getMaxEnergyStored() : 0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return DuctUnitEnergy.this.receiveEnergy(maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return DuctUnitEnergy.this.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return DuctUnitEnergy.this.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }
        });
    }

    public static class Cache
    implements IEnergyReceiver,
    IEnergyProvider {
        public IEnergyHandler handler;
        public IEnergyReceiver receiver;
        public IEnergyProvider provider;

        public Cache(IEnergyReceiver receiver) {
            this.handler = receiver;
            this.receiver = receiver;
            if (receiver instanceof IEnergyProvider) {
                this.provider = (IEnergyProvider)receiver;
            }
        }

        public Cache(IEnergyProvider provider) {
            this.handler = provider;
            this.provider = provider;
            if (provider instanceof IEnergyReceiver) {
                this.receiver = (IEnergyReceiver)provider;
            }
        }

        public boolean canConnectEnergy(EnumFacing from) {
            return this.handler.canConnectEnergy(from);
        }

        public int getEnergyStored(EnumFacing from) {
            return this.handler.getEnergyStored(from);
        }

        public int getMaxEnergyStored(EnumFacing from) {
            return this.handler.getMaxEnergyStored(from);
        }

        public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
            return this.receiver == null ? 0 : this.receiver.receiveEnergy(from, maxReceive, simulate);
        }

        public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
            return this.provider == null ? 0 : this.provider.extractEnergy(from, maxExtract, simulate);
        }
    }
}

