/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.servo;

import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.FluidTankGrid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ServoFluid
extends ServoBase {
    public static float[] throttle = new float[]{0.5f, 0.75f, 1.0f, 1.5f, 2.0f};
    public DuctUnitFluid fluidDuct;

    @Override
    public int getId() {
        return 1;
    }

    public ServoFluid(TileGrid tile, byte side) {
        super(tile, side);
        this.fluidDuct = (DuctUnitFluid)tile.getDuct(DuctToken.FLUID);
    }

    public ServoFluid(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        this.fluidDuct = (DuctUnitFluid)tile.getDuct(DuctToken.FLUID);
    }

    @Override
    public DuctToken tickUnit() {
        return DuctToken.FLUID;
    }

    @Override
    public void clearCache() {
        this.myTile = null;
    }

    @Override
    public void cacheTile(TileEntity tile) {
        this.myTile = tile;
    }

    @Override
    public boolean isValidTile(TileEntity tile) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
    }

    @Override
    public boolean canAddToTile(TileGrid tile) {
        return this.fluidDuct != null;
    }

    @Override
    public void tick(int pass) {
        super.tick(pass);
        if (pass != 1 || this.fluidDuct.getGrid() == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        FluidTankGrid myTank = ((GridFluid)this.fluidDuct.getGrid()).myTank;
        int maxInput = (int)Math.ceil((float)myTank.fluidThroughput * throttle[this.type]);
        IFluidHandler ductHandler = this.fluidDuct.getFluidCapability(EnumFacing.field_82609_l[this.side]);
        if (ductHandler == null) {
            return;
        }
        IFluidHandler tileHandler = this.getMyTile();
        if (tileHandler == null) {
            return;
        }
        maxInput = myTank.fill(tileHandler.drain(maxInput, false), false);
        myTank.fill(tileHandler.drain(maxInput, true), true);
    }

    public boolean fluidPassesFiltering(FluidStack theFluid) {
        return theFluid != null && this.filter.allowFluid(theFluid);
    }

    @Override
    public FilterLogic createFilterLogic() {
        return new FilterLogic(this.type, Duct.Type.FLUID, this);
    }

    public IFluidHandler getMyTile() {
        if (this.myTile == null) {
            return null;
        }
        return (IFluidHandler)this.myTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
    }
}

