/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import cofh.thermaldynamics.init.TDItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class CoverHelper {
    public static boolean isValid(ItemStack stack) {
        try {
            return stack.func_77973_b() instanceof ItemBlock && CoverHelper.isValid(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77973_b().func_77647_b(stack.func_77952_i()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isValid(Block block, int meta) {
        try {
            if (block == null || block instanceof IShearable) {
                return false;
            }
            IBlockState state = block.func_176203_a(meta);
            return !block.hasTileEntity(state) && !block.func_149716_u() && state.func_185917_h();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ItemStack getCoverStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return CoverHelper.getCoverStack(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77973_b().func_77647_b(stack.func_77952_i()));
        }
        return null;
    }

    public static ItemStack getCoverStack(IBlockState state) {
        return CoverHelper.getCoverStack(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public static ItemStack getCoverStack(Block block, int meta) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block).toString());
        tag.func_74774_a("Meta", (byte)meta);
        ItemStack itemStack = new ItemStack((Item)TDItems.itemCover, 1);
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    public static ItemStack getCoverItemStack(ItemStack stack, boolean removeInvalidData) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Meta", 1) || !nbt.func_150297_b("Block", 8)) {
            return null;
        }
        byte meta = nbt.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || meta < 0 || meta >= 16 || !CoverHelper.isValid(block, meta)) {
            if (removeInvalidData) {
                nbt.func_82580_o("Meta");
                nbt.func_82580_o("Block");
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            return null;
        }
        return new ItemStack(block, 1, (int)meta);
    }
}

