/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments;

import codechicken.lib.vec.Cuboid6;
import cofh.api.core.IPortableData;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.tileentity.IRedstoneControl;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.IStuffable;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.filter.IFilterAttachment;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.gui.client.GuiDuctConnection;
import cofh.thermaldynamics.gui.container.ContainerDuctConnection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ConnectionBase
extends Attachment
implements IStuffable,
IRedstoneControl,
IFilterAttachment,
IPortableData {
    public boolean stuffed = false;
    public int type = 0;
    public boolean isValidInput;
    public boolean isPowered = false;
    public IRedstoneControl.ControlMode rsMode = IRedstoneControl.ControlMode.HIGH;
    public FilterLogic filter;
    int prevFlag = -1;

    public ConnectionBase(TileGrid tile, byte side) {
        super(tile, side);
    }

    public ConnectionBase(TileGrid tile, byte side, int type) {
        this(tile, side);
        this.type = type;
        this.filter = this.createFilterLogic();
    }

    public abstract void cacheTile(TileEntity var1);

    public abstract void clearCache();

    public abstract boolean isValidTile(TileEntity var1);

    public abstract FilterLogic createFilterLogic();

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    @Nonnull
    public BlockDuct.ConnectionType getNeighborType() {
        return BlockDuct.ConnectionType.DUCT;
    }

    @Override
    public Cuboid6 getCuboid() {
        return TileGrid.subSelection[this.side].copy();
    }

    @Override
    public void checkSignal() {
        boolean wasPowered = this.isPowered;
        boolean bl = this.isPowered = this.rsMode.isDisabled() || this.rsMode.getState() == this.getPowerState();
        if (wasPowered != this.isPowered) {
            BlockHelper.callBlockUpdate((World)this.baseTile.func_145831_w(), (BlockPos)this.baseTile.func_174877_v());
        }
    }

    @Override
    public void onNeighborChange() {
        super.onNeighborChange();
        TileEntity adjacentTileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this.baseTile, (int)this.side);
        this.clearCache();
        boolean wasValidInput = this.isValidInput;
        this.isValidInput = this.isValidTile(adjacentTileEntity);
        if (this.isValidInput) {
            this.cacheTile(adjacentTileEntity);
        }
        boolean wasPowered = this.isPowered;
        boolean bl = this.isPowered = this.rsMode.isDisabled() || this.rsMode.getState() == this.getPowerState();
        if (wasPowered != this.isPowered || this.isValidInput != wasValidInput) {
            BlockHelper.callBlockUpdate((World)this.baseTile.func_145831_w(), (BlockPos)this.baseTile.func_174877_v());
        }
    }

    public boolean canAlterRS() {
        return false;
    }

    public boolean getPowerState() {
        return this.baseTile.isPowered();
    }

    @Override
    public boolean respondsToSignalum() {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> drops = new LinkedList<ItemStack>();
        drops.add(this.getPickBlock());
        return drops;
    }

    public FilterLogic getFilter() {
        if (this.filter == null) {
            this.filter = this.createFilterLogic();
        }
        return this.filter;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.type = tag.func_74771_c("type") % 5;
        this.filter = this.createFilterLogic();
        this.filter.readFromNBT(tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("type", (byte)this.type);
        this.filter.writeToNBT(tag);
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packet) {
        packet.addBool(this.stuffed);
        packet.addByte(this.type);
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packet) {
        this.stuffed = packet.getBool();
        this.type = packet.getByte();
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase payload, boolean isServer, EntityPlayer player) {
        super.handleInfoPacket(payload, isServer, player);
        byte a = payload.getByte();
        this.handleInfoPacketType(a, payload, isServer, player);
    }

    public PacketTileInfo getNewPacket(byte type) {
        PacketTileInfo packet = this.getNewPacket();
        packet.addByte(type);
        return packet;
    }

    public void handleInfoPacketType(byte a, PacketCoFHBase payload, boolean isServer, EntityPlayer player) {
        if (a == 1) {
            if (this.canAlterRS()) {
                this.setControl(IRedstoneControl.ControlMode.values()[payload.getByte()]);
            }
        } else if (a == 2) {
            byte aByte;
            this.filter.setFlag(aByte >> 1, ((aByte = payload.getByte()) & 1) == 1);
            this.filter.recalc = true;
        } else if (a == 3) {
            byte b = payload.getByte();
            short c = payload.getShort();
            this.filter.setLevel(b, c);
            this.filter.recalc = true;
        }
    }

    public void sendFilterConfigPacketFlag(int flagType, boolean flag) {
        PacketTileInfo packet = this.getNewPacket((byte)2);
        packet.addByte(flagType << 1 | (flag ? 1 : 0));
        PacketHandler.sendToServer((PacketBase)packet);
    }

    public void sendFilterConfigPacketLevel(int levelType, int level) {
        PacketTileInfo packet = this.getNewPacket((byte)3);
        packet.addByte(levelType);
        packet.addShort(level);
        PacketHandler.sendToServer((PacketBase)packet);
    }

    @Override
    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDuctConnection(inventory, this);
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDuctConnection(inventory, this);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (ServerHelper.isServerWorld((World)this.baseTile.world())) {
            player.openGui((Object)ThermalDynamics.instance, 10 + this.side, this.baseTile.func_145831_w(), this.baseTile.x(), this.baseTile.y(), this.baseTile.z());
        }
        return true;
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        super.receiveGuiNetworkData(i, j);
        if (i == 0) {
            this.filter.handleFlagByte(j);
        } else {
            this.filter.setLevel(i - 1, j, false);
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, List<IContainerListener> players, boolean newListener) {
        super.sendGuiNetworkData(container, players, newListener);
        int flagByte = this.filter.getFlagByte();
        if (flagByte != this.prevFlag || newListener) {
            for (IContainerListener player : players) {
                player.func_71112_a(container, 0, flagByte);
            }
        }
        this.prevFlag = flagByte;
        if (this.filter.levelsChanged || newListener) {
            for (int i = 0; i < FilterLogic.defaultLevels.length; ++i) {
                for (IContainerListener player : players) {
                    player.func_71112_a(container, 1 + i, this.filter.getLevel(i));
                }
            }
            this.filter.levelsChanged = false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask() {
        return CoverHoleRender.hollowDuctTile;
    }

    @Override
    public IFilterItems getItemFilter() {
        return this.filter;
    }

    @Override
    public IFilterFluid getFluidFilter() {
        return this.filter;
    }

    public String getDataType() {
        return "ConnectionBase";
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        if (this.canAlterRS() && tag.func_74764_b("RSControl")) {
            this.setControl(RedstoneControlHelper.getControlFromNBT((NBTTagCompound)tag));
        }
        this.filter.readFromNBT(tag);
        this.onNeighborChange();
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        if (this.canAlterRS()) {
            RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)tag, (IRedstoneControl)this);
        }
        this.filter.writeToNBT(tag);
    }

    @Override
    public void stuffItem(ItemStack item) {
    }

    @Override
    public boolean canStuff() {
        return false;
    }

    @Override
    public boolean isStuffed() {
        return false;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean setControl(IRedstoneControl.ControlMode control) {
        if (!this.canAlterRS()) {
            return false;
        }
        this.rsMode = control;
        if (ServerHelper.isClientWorld((World)this.baseTile.world())) {
            PacketTileInfo packet = this.getNewPacket((byte)1);
            packet.addByte(this.rsMode.ordinal());
            PacketHandler.sendToServer((PacketBase)packet);
        } else {
            this.onNeighborChange();
        }
        return true;
    }

    public IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    public static class NETWORK_ID {
        public static final byte GUI = 0;
        public static final byte RSCONTROL = 1;
        public static final byte FILTERFLAG = 2;
        public static final byte FILTERLEVEL = 3;
    }
}

