/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.api.ToastHandler;
import net.blay09.mods.cookingforblockheads.api.ToastOutputHandler;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileToaster
extends TileEntity
implements ITickable {
    private static final int TOAST_TICKS = 1200;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileToaster.this.func_70296_d();
            VanillaPacketHandler.sendTileEntityUpdate(TileToaster.this);
        }
    };
    private boolean active;
    private int toastTicks;

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.active = tagCompound.func_74767_n("Active");
        this.toastTicks = tagCompound.func_74762_e("ToastTicks");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74757_a("Active", this.active);
        tagCompound.func_74768_a("ToastTicks", this.toastTicks);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void func_73660_a() {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0 && !this.field_145850_b.field_72995_K) {
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    ItemStack inputStack = this.itemHandler.getStackInSlot(i);
                    if (inputStack == null) continue;
                    ToastHandler toastHandler = CookingRegistry.getToastHandler(inputStack);
                    ItemStack outputStack = toastHandler instanceof ToastOutputHandler ? ((ToastOutputHandler)toastHandler).getToasterOutput(inputStack) : null;
                    outputStack = outputStack == null ? inputStack : outputStack.func_77946_l();
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.75f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), outputStack);
                    entityItem.field_70159_w = 0.0;
                    entityItem.field_70181_x = 0.1f;
                    entityItem.field_70179_y = 0.0;
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                    this.itemHandler.setStackInSlot(i, null);
                }
                this.setActive(false);
            }
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        this.toastTicks = active ? 1200 : 0;
        VanillaPacketHandler.sendTileEntityUpdate(this);
    }

    public boolean isActive() {
        return this.active;
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public float getToastProgress() {
        return 1.0f - (float)this.toastTicks / 1200.0f;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

