/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMilkJar
extends TileEntity {
    protected static final int MILK_CAPACITY = 8000;
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);
    protected float milkAmount;

    public void fill(int amount) {
        this.milkAmount = Math.min(8000.0f, this.milkAmount + (float)amount);
        VanillaPacketHandler.sendTileEntityUpdate(this);
    }

    public void drain(int amount) {
        this.milkAmount = Math.max(0.0f, this.milkAmount - (float)amount);
        VanillaPacketHandler.sendTileEntityUpdate(this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74776_a("MilkAmount", this.milkAmount);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.milkAmount = tagCompound.func_74760_g("MilkAmount");
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public float getMilkAmount() {
        return this.milkAmount;
    }

    public float getMilkCapacity() {
        return 8000.0f;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityKitchenItemProvider.CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return (T)this.itemProvider;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private static class MilkJarItemProvider
    implements IKitchenItemProvider {
        private final List<ItemStack> itemStacks = Lists.newArrayList();
        private final TileMilkJar tileMilkJar;
        private int milkUsed;

        public MilkJarItemProvider(TileMilkJar tileMilkJar) {
            this.tileMilkJar = tileMilkJar;
            this.itemStacks.add(new ItemStack(Items.field_151117_aB));
            this.itemStacks.addAll(CookingRegistry.getMilkItems());
        }

        @Override
        public void resetSimulation() {
            this.milkUsed = 0;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (this.tileMilkJar.getMilkAmount() - (float)this.milkUsed >= (float)(amount * 1000)) {
                if (requireBucket && this.getStackInSlot(slot).func_77973_b() == Items.field_151117_aB && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return null;
                }
                if (simulate) {
                    this.milkUsed += amount * 1000;
                } else {
                    this.tileMilkJar.drain(amount * 1000);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStackInSlot(slot), (int)amount);
            }
            return null;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemStack, (ItemStack)providedStack)) continue;
                this.tileMilkJar.fill(1000);
                break;
            }
            return null;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.itemStacks.get(slot);
        }
    }
}

