/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageRecipes
implements IMessage {
    private ItemStack outputItem;
    private List<FoodRecipeWithIngredients> recipeList;

    public MessageRecipes() {
    }

    public MessageRecipes(ItemStack outputItem, List<FoodRecipeWithIngredients> recipeList) {
        this.outputItem = outputItem;
        this.recipeList = recipeList;
    }

    public void fromBytes(ByteBuf buf) {
        this.outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        int recipeCount = buf.readInt();
        this.recipeList = Lists.newArrayListWithCapacity((int)recipeCount);
        for (int i = 0; i < recipeCount; ++i) {
            this.recipeList.add(FoodRecipeWithIngredients.read(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.outputItem);
        buf.writeInt(this.recipeList.size());
        for (FoodRecipeWithIngredients recipe : this.recipeList) {
            recipe.write(buf);
        }
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public List<FoodRecipeWithIngredients> getRecipeList() {
        return this.recipeList;
    }
}

