/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.ToastOutputHandler;
import net.blay09.mods.cookingforblockheads.compat.SimpleAddon;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class HarvestCraftAddon
extends SimpleAddon {
    private static final String[] ADDITIONAL_RECIPES = new String[]{"flourItem", "doughItem", "cornmealItem", "freshwaterItem", "pastaItem", "vanillaItem", "butterItem", "heavycreamItem", "saltItem", "freshmilkItem", "mayoItem", "cocoapowderItem", "ketchupItem", "vinegarItem", "mustardItem", "blackpepperItem", "groundcinnamonItem", "groundnutmegItem", "saladdressingItem", "batterItem", "oliveoilItem", "hotsauceitem", "sweetandsoursauceitem", "fivespiceitem", "hoisinsauceitem", "noodlesitem", "sesameoilitem", "garammasalaitem", "soysauceitem", "currypowderitem", "bubblywateritem", "carrotcakeItem", "holidaycakeItem", "pumpkincheesecakeItem", "pavlovaItem", "lamingtonItem", "cheesecakeItem", "cherrycheesecakeItem", "pineappleupsidedowncakeItem", "chocolatesprinklecakeItem", "redvelvetcakeItem"};
    private static final String[] OVEN_RECIPES = new String[]{"turkeyrawItem", "turkeycookedItem", "rabbitrawItem", "rabbitcookedItem", "venisonrawItem", "venisoncookedItem"};
    private static final String[] TOOLS = new String[]{"cuttingboardItem", "potItem", "skilletItem", "saucepanItem", "bakewareItem", "mortarandpestleItem", "mixingbowlItem", "juicerItem"};
    private static final String OLIVE_OIL_ITEM = "oliveoilItem";
    private static final String TOAST_ITEM = "toastItem";
    private static final String FRESH_WATER_ITEM = "freshwaterItem";
    private static final String FRESH_MILK_ITEM = "freshmilkItem";

    public HarvestCraftAddon() {
        super("harvestcraft");
        ItemStack oliveOil = this.getModItemStack(OLIVE_OIL_ITEM);
        if (oliveOil != null) {
            CookingForBlockheadsAPI.addOvenFuel(oliveOil, 1600);
        }
        for (int i = 0; i < OVEN_RECIPES.length; i += 2) {
            ItemStack sourceItem = this.getModItemStack(OVEN_RECIPES[i]);
            ItemStack resultItem = this.getModItemStack(OVEN_RECIPES[i + 1]);
            if (sourceItem == null || resultItem == null) continue;
            CookingForBlockheadsAPI.addOvenRecipe(sourceItem, resultItem);
        }
        final ItemStack toastItem = this.getModItemStack(TOAST_ITEM);
        if (toastItem != null) {
            CookingForBlockheadsAPI.addToastHandler(new ItemStack(Items.field_151025_P), new ToastOutputHandler(){

                @Override
                public ItemStack getToasterOutput(ItemStack itemStack) {
                    return toastItem;
                }
            });
        }
        this.addNonFoodRecipe(ADDITIONAL_RECIPES);
        this.addTool(TOOLS);
        CookingForBlockheadsAPI.addWaterItem(this.getModItemStack(FRESH_WATER_ITEM));
        CookingForBlockheadsAPI.addMilkItem(this.getModItemStack(FRESH_MILK_ITEM));
    }

    public static boolean isWeirdBrokenRecipe(IRecipe recipe) {
        if (recipe.func_77570_a() == 2 && recipe instanceof ShapelessOreRecipe) {
            List list;
            ShapelessOreRecipe oreRecipe = (ShapelessOreRecipe)recipe;
            Object first = oreRecipe.getInput().get(0);
            Object second = oreRecipe.getInput().get(1);
            ItemStack firstItem = null;
            ItemStack secondItem = null;
            if (first instanceof ItemStack) {
                firstItem = (ItemStack)first;
            } else if (first instanceof ArrayList && (list = (List)first).size() == 1) {
                firstItem = (ItemStack)list.get(0);
            }
            if (second instanceof ItemStack) {
                secondItem = (ItemStack)second;
            } else if (second instanceof ArrayList && (list = (List)second).size() == 1) {
                secondItem = (ItemStack)list.get(0);
            }
            if (firstItem != null && secondItem != null && ItemStack.func_77989_b((ItemStack)firstItem, (ItemStack)secondItem) && oreRecipe.func_77571_b() != null && oreRecipe.func_77571_b().func_77969_a(firstItem)) {
                return true;
            }
        }
        return false;
    }
}

