/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.tooltip;

import com.google.common.collect.Lists;
import elec332.core.client.util.GuiDraw;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolTip {
    private int width = -1;
    private final List<String> tooltip;

    public ToolTip() {
        this((ColouredString)null);
    }

    public ToolTip(ColouredString colouredString) {
        this(Lists.newArrayList((Object[])new ColouredString[]{colouredString}));
    }

    public ToolTip(List<ColouredString> s) {
        this.tooltip = s.stream().map(ColouredString::toString).collect(Collectors.toList());
    }

    public ToolTip(String s) {
        this(Lists.newArrayList((Object[])new String[]{s}), new Object[0]);
    }

    public ToolTip(List<String> s, Object ... o) {
        this.tooltip = s;
    }

    public ToolTip setWidth(int width) {
        this.width = width;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTooltip(int mouseX, int mouseY, int guiLeft, int guiTop) {
        GlStateManager.func_179094_E();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ArrayList tooltip = this.tooltip;
        if (!tooltip.isEmpty()) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179109_b((float)mouseX, (float)mouseY, (float)0.0f);
            int k = 0;
            if (this.width == -1) {
                for (String colouredString : tooltip) {
                    int l = fontRenderer.func_78256_a(colouredString);
                    if (l <= k) continue;
                    k = l;
                }
            } else {
                tooltip = Lists.newArrayList();
                for (String s : this.tooltip) {
                    for (String s1 : fontRenderer.func_78271_c(s, this.width)) {
                        tooltip.add(s1);
                        int l = fontRenderer.func_78256_a(s1);
                        if (l <= k) continue;
                        k = l;
                    }
                }
            }
            int j2 = mouseX + 12;
            int k2 = mouseY - 12;
            int i1 = 8;
            if (tooltip.size() > 1) {
                i1 += 2 + (tooltip.size() - 1) * 10;
            }
            if (j2 + k > guiLeft) {
                j2 -= 28 + k;
            }
            if (k2 + i1 + 6 > guiTop) {
                k2 = guiTop - i1 - 6;
            }
            int j1 = -267386864;
            GuiDraw.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            GuiDraw.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            GuiDraw.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            GuiDraw.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            GuiDraw.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            GuiDraw.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            GuiDraw.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            GuiDraw.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            GuiDraw.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                String s1 = (String)tooltip.get(i2);
                fontRenderer.func_175063_a(s1, (float)j2, (float)k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
        }
        GlStateManager.func_179121_F();
    }

    public static class ColouredString {
        private final String string;

        public ColouredString(String s) {
            this(TextFormatting.GRAY, s);
        }

        public ColouredString(TextFormatting colour, String s) {
            this.string = colour + s;
        }

        public String toString() {
            return this.string;
        }
    }
}

