/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler;

import com.google.common.collect.Sets;
import elec332.core.api.callback.CallbackProcessor;
import elec332.core.api.callback.ICallbackProcessor;
import elec332.core.main.ElecCore;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;

@CallbackProcessor
public final class ModEventHandler
implements ICallbackProcessor {
    private static Set<Callback> callbacks;
    private static boolean locked;

    private ModEventHandler() {
    }

    public static boolean registerCallback(Callback callback) {
        return !locked && callbacks.add(callback);
    }

    @Override
    public void getCallbacks(List<?> callbacks) {
        for (Object o : callbacks) {
            if (!(o instanceof Callback)) continue;
            ModEventHandler.callbacks.add((Callback)o);
        }
    }

    public void postEvent(FMLStateEvent event) {
        if (event instanceof FMLConstructionEvent) {
            return;
        }
        if (event instanceof FMLPreInitializationEvent) {
            event = new FMLPreInitializationEvent(new Object[]{((FMLPreInitializationEvent)event).getAsmData(), ((FMLPreInitializationEvent)event).getModConfigurationDirectory()});
        }
        if (!locked) {
            locked = true;
        }
        this.postEventChecked(event);
    }

    private void postEventChecked(FMLStateEvent event) {
        for (Callback callback : callbacks) {
            callback.onEvent(event);
        }
    }

    static {
        locked = false;
        callbacks = Sets.newHashSet();
        ElecCore.instance.setModEventHandler(new ModEventHandler());
    }

    public static interface Callback {
        public void onEvent(FMLStateEvent var1);
    }
}

