/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.effects.api.util;

import elec332.core.effects.api.ElecCoreAbilitiesAPI;
import elec332.core.effects.api.ability.Ability;
import elec332.core.effects.api.ability.WrappedAbility;
import elec332.core.effects.api.util.IEntityAbilityProperties;
import net.minecraft.entity.EntityLivingBase;

public class AbilityHelper {
    private AbilityHelper() {
        throw new IllegalAccessError();
    }

    public static void addEffectToEntity(EntityLivingBase entity, WrappedAbility effect) {
        IEntityAbilityProperties handler = AbilityHelper.getHandler(entity);
        if (handler != null) {
            handler.addEffect(effect);
        }
    }

    public static void removeEffectFromEntity(EntityLivingBase entity, WrappedAbility effect) {
        IEntityAbilityProperties handler = AbilityHelper.getHandler(entity);
        if (handler != null) {
            handler.removeEffect(effect);
        }
    }

    public static WrappedAbility getActiveEffect(EntityLivingBase entity, Ability ability) {
        return AbilityHelper.getActiveEffect(entity, ability.getName());
    }

    public static WrappedAbility getActiveEffect(EntityLivingBase entity, String effect) {
        IEntityAbilityProperties handler = AbilityHelper.getHandler(entity);
        if (handler != null) {
            return handler.getEffect(effect);
        }
        return null;
    }

    public static boolean isEffectActive(EntityLivingBase entity, String effect) {
        return AbilityHelper.getActiveEffect(entity, effect) != null;
    }

    public static boolean isEffectActive(EntityLivingBase entity, Ability ability) {
        return AbilityHelper.getActiveEffect(entity, ability) != null;
    }

    public static IEntityAbilityProperties getHandler(EntityLivingBase entity) {
        return (IEntityAbilityProperties)entity.getCapability(ElecCoreAbilitiesAPI.ABILITIES_CAPABILITY, null);
    }
}

