/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.allele;

import elec332.core.compat.forestry.allele.AbstractAllele;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class AlleleFlowerProvider
extends AbstractAllele
implements IAlleleFlowers {
    private final IFlowerProvider flowerProvider;

    public AlleleFlowerProvider(ResourceLocation rl, IFlowerProvider flowerProvider) {
        super(rl, new IChromosomeType[]{EnumBeeChromosome.FLOWER_PROVIDER});
        this.flowerProvider = flowerProvider;
    }

    public AlleleFlowerProvider(String s, IFlowerProvider flowerProvider) {
        super(s, new IChromosomeType[]{EnumBeeChromosome.FLOWER_PROVIDER});
        this.flowerProvider = flowerProvider;
    }

    public AlleleFlowerProvider(String uid, String unlocalizedName, IFlowerProvider flowerProvider) {
        super(uid, unlocalizedName, new IChromosomeType[]{EnumBeeChromosome.FLOWER_PROVIDER});
        this.flowerProvider = flowerProvider;
    }

    public IFlowerProvider getProvider() {
        return this.flowerProvider;
    }

    public void registerGrowthRule(IFlowerGrowthRule iFlowerGrowthRule) {
        FlowerManager.flowerRegistry.registerGrowthRule(iFlowerGrowthRule, new String[]{this.flowerProvider.getFlowerType()});
    }

    public void registerAcceptableFlower(Block block) {
        FlowerManager.flowerRegistry.registerAcceptableFlower(block, new String[]{this.flowerProvider.getFlowerType()});
    }

    public void registerAcceptableFlower(IBlockState iBlockState) {
        FlowerManager.flowerRegistry.registerAcceptableFlower(iBlockState, new String[]{this.flowerProvider.getFlowerType()});
    }

    public void registerAcceptableFlowerRule(IFlowerAcceptableRule iFlowerAcceptableRule) {
        FlowerManager.flowerRegistry.registerAcceptableFlowerRule(iFlowerAcceptableRule, new String[]{this.flowerProvider.getFlowerType()});
    }

    public void registerPlantableFlower(IBlockState iBlockState, double v) {
        FlowerManager.flowerRegistry.registerPlantableFlower(iBlockState, v, new String[]{this.flowerProvider.getFlowerType()});
    }
}

