/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.template;

import elec332.core.api.client.model.template.IMutableQuadTemplate;
import elec332.core.api.client.model.template.IQuadTemplate;
import elec332.core.client.RenderHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class MutableQuadTemplate
implements IMutableQuadTemplate {
    private static final IQuadTemplate.IUVData DEFAULT_UV = MutableQuadTemplate.makeImmutable(MutableQuadTemplate.forUV(0.0f, 0.0f, 16.0f, 16.0f));
    private Vector3f v1;
    private Vector3f v2;
    private TextureAtlasSprite texture;
    private EnumFacing side;
    private ModelRotation rotation;
    private IQuadTemplate.IUVData uvData = DEFAULT_UV;
    private int tintIndex;

    @Nonnull
    public static MutableQuadTemplate templateForTexture(EnumFacing side, TextureAtlasSprite texture) {
        return MutableQuadTemplate.newTemplate(side).setTexture(texture);
    }

    @Nonnull
    public static MutableQuadTemplate newTemplate(EnumFacing side) {
        return new MutableQuadTemplate(side);
    }

    @Nonnull
    public static MutableQuadTemplate copyOf(IQuadTemplate template) {
        if (template == null) {
            return MutableQuadTemplate.newTemplate(EnumFacing.UP);
        }
        MutableQuadTemplate ret = new MutableQuadTemplate(template.getSide());
        ret.v1 = new Vector3f((ReadableVector3f)template.getV1());
        ret.v2 = new Vector3f((ReadableVector3f)template.getV2());
        ret.texture = template.getTexture();
        ret.rotation = template.getRotation();
        ret.uvData = MutableQuadTemplate.makeImmutable(template.getUVData());
        return ret;
    }

    private MutableQuadTemplate(EnumFacing side) {
        this.rotation = ModelRotation.X0_Y0;
        this.side = side;
        this.texture = RenderHelper.getMissingTextureIcon();
        this.v1 = new Vector3f(0.0f, 0.0f, 0.0f);
        this.v2 = new Vector3f(16.0f, 16.0f, 16.0f);
        this.tintIndex = -1;
    }

    @Override
    public MutableQuadTemplate setV1(Vector3f v1) {
        this.v1 = v1;
        return this;
    }

    @Override
    public MutableQuadTemplate setV2(Vector3f v2) {
        this.v2 = v2;
        return this;
    }

    @Override
    public MutableQuadTemplate setTexture(TextureAtlasSprite texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public MutableQuadTemplate setSide(EnumFacing side) {
        this.side = side;
        return this;
    }

    @Override
    public MutableQuadTemplate setRotation(ModelRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    @Override
    public MutableQuadTemplate setUvData(IQuadTemplate.IUVData uvData) {
        this.uvData = uvData;
        return this;
    }

    @Override
    public MutableQuadTemplate setTintIndex(int tintIndex) {
        if (tintIndex < -1) {
            throw new IllegalArgumentException();
        }
        this.tintIndex = tintIndex;
        return this;
    }

    @Override
    public Vector3f getV1() {
        return this.v1;
    }

    @Override
    public Vector3f getV2() {
        return this.v2;
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return RenderHelper.checkIcon(this.texture);
    }

    @Override
    public EnumFacing getSide() {
        return this.side;
    }

    @Override
    public ModelRotation getRotation() {
        return this.rotation;
    }

    @Override
    public IQuadTemplate.IUVData getUVData() {
        return this.uvData;
    }

    @Override
    public int getTintIndex() {
        return this.tintIndex;
    }

    public static IQuadTemplate.IMutableUVData forUV(float f1, float f2, float f3, float f4) {
        return new MutableUVData(f1, f2, f3, f4);
    }

    public static IQuadTemplate.IUVData makeImmutable(IQuadTemplate.IUVData data) {
        return new ImmutableUVData(data);
    }

    private static class ImmutableUVData
    implements IQuadTemplate.IUVData {
        private final float uMin;
        private final float vMin;
        private final float uMax;
        private final float vMax;

        private ImmutableUVData(IQuadTemplate.IUVData from) {
            this(from.getUMin(), from.getVMin(), from.getUMax(), from.getVMax());
        }

        private ImmutableUVData(float f1, float f2, float f3, float f4) {
            this.uMin = f1;
            this.vMin = f2;
            this.uMax = f3;
            this.vMax = f4;
        }

        @Override
        public float getUMin() {
            return this.uMin;
        }

        @Override
        public float getVMin() {
            return this.vMin;
        }

        @Override
        public float getUMax() {
            return this.uMax;
        }

        @Override
        public float getVMax() {
            return this.vMax;
        }
    }

    private static class MutableUVData
    implements IQuadTemplate.IMutableUVData {
        private float uMin;
        private float vMin;
        private float uMax;
        private float vMax;

        private MutableUVData(float f1, float f2, float f3, float f4) {
            this.uMin = f1;
            this.vMin = f2;
            this.uMax = f3;
            this.vMax = f4;
        }

        @Override
        public IQuadTemplate.IMutableUVData setUMin(float f) {
            this.uMin = f;
            return this;
        }

        @Override
        public IQuadTemplate.IMutableUVData setVMin(float f) {
            this.vMin = f;
            return this;
        }

        @Override
        public IQuadTemplate.IMutableUVData setUMax(float f) {
            this.uMax = f;
            return this;
        }

        @Override
        public IQuadTemplate.IMutableUVData setVMax(float f) {
            this.vMax = f;
            return this;
        }

        @Override
        public float getUMin() {
            return this.uMin;
        }

        @Override
        public float getVMin() {
            return this.vMin;
        }

        @Override
        public float getUMax() {
            return this.uMax;
        }

        @Override
        public float getVMax() {
            return this.vMax;
        }
    }
}

