/*
 * Decompiled with CFR 0.152.
 */
package elec332.abstraction.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.abstraction.handlers.IAbstractedClassProvider;
import elec332.abstraction.handlers.IAbstractionLayer;
import elec332.abstraction.handlers.IEntityAbstraction;
import elec332.abstraction.handlers.IGeneralAbstraction;
import elec332.abstraction.handlers.IInventoryAbstraction;
import elec332.abstraction.handlers.IWorldAbstraction;
import elec332.abstraction.impl.EntityAbstraction;
import elec332.abstraction.impl.MCAbstractedAbstractedItem;
import elec332.abstraction.impl.MCAbstractionInst;
import elec332.abstraction.impl.WorldEventListener;
import elec332.core.inventory.widget.slot.WidgetSlot;
import elec332.core.util.ItemStackHelper;
import elec332.core.util.MinecraftList;
import elec332.core.world.IElecWorldEventListener;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class MCAbstractionHandler
implements IAbstractionLayer,
IWorldAbstraction,
IInventoryAbstraction,
IGeneralAbstraction,
IAbstractedClassProvider {
    static final Set<IElecWorldEventListener> listeners = Sets.newHashSet();

    public MCAbstractionHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void unRegisterWorldEventListener_(IElecWorldEventListener listener) {
        listeners.add(listener);
    }

    public static void registerWorldEventListener_(IElecWorldEventListener listener) {
        listeners.add(listener);
    }

    @Override
    @Nonnull
    public IAbstractedClassProvider getClassProvider() {
        return this;
    }

    @Override
    @Nonnull
    public Class<? extends IWorldAbstraction> getWorldAbstraction() {
        return this.getClass();
    }

    @Override
    @Nonnull
    public Class<? extends IInventoryAbstraction> getInventoryAbstraction() {
        return this.getClass();
    }

    @Override
    @Nonnull
    public Class<? extends IEntityAbstraction> getEntityAbstraction() {
        return EntityAbstraction.class;
    }

    @Override
    @Nonnull
    public Class<? extends IGeneralAbstraction> getGeneralAbstraction() {
        return this.getClass();
    }

    @Override
    public void unRegisterWorldEventListener(IElecWorldEventListener listener) {
        MCAbstractionHandler.unRegisterWorldEventListener_(listener);
    }

    @Override
    public void registerWorldEventListener(IElecWorldEventListener listener) {
        MCAbstractionHandler.registerWorldEventListener_(listener);
    }

    @Override
    public IBlockState getBlockStateForPlacement(Block block, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, @Nonnull EnumHand hand) {
        return block.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, placer.func_184586_b(hand));
    }

    @Override
    public boolean canBlockBePlaced(World world, Block block, BlockPos pos, boolean b, EnumFacing facing, @Nullable Entity entity) {
        return world.func_175716_a(block, pos, b, facing, entity, null);
    }

    @Override
    public void notifyNeighborsOfStateChange(World world, BlockPos pos, Block block) {
        world.func_175685_c(pos, block);
    }

    @Override
    public <E> List<E> createList() {
        return Lists.newArrayList();
    }

    @Override
    public <E> List<E> createList(int size, E defaultObj) {
        Object[] o = new Object[size];
        Arrays.fill(o, defaultObj);
        return Arrays.asList(o);
    }

    @Override
    public ItemStack getAndRemove(List<ItemStack> stacks, int index) {
        return net.minecraft.inventory.ItemStackHelper.func_188383_a((ItemStack[])stacks.toArray(new ItemStack[stacks.size()]), (int)index);
    }

    @Override
    public ItemStack getAndSplit(List<ItemStack> stacks, int index, int amount) {
        return net.minecraft.inventory.ItemStackHelper.func_188382_a((ItemStack[])stacks.toArray(new ItemStack[stacks.size()]), (int)index, (int)amount);
    }

    @Override
    public ItemStack loadItemStackFromNBT(NBTTagCompound tag) {
        return ItemStack.func_77949_a((NBTTagCompound)tag);
    }

    @Override
    public int getSlotStackLimit(IItemHandler itemHandler, int slot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemStack onPickupFromSlot(Slot slot, EntityPlayer player, ItemStack stack) {
        slot.func_82870_a(player, stack);
        return stack;
    }

    @Override
    public EnumActionResult fireOnItemUse(Item item, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return item.func_180614_a(playerIn.func_184586_b(hand), playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void updateCraftingInventory(IContainerListener listener, Container container, List<ItemStack> itemsList) {
        if (itemsList instanceof MinecraftList) {
            itemsList = ((MinecraftList)itemsList).getUnderlyingList();
        }
        listener.func_71110_a(container, itemsList);
    }

    @Override
    public ItemStack getNullStack() {
        return null;
    }

    @Override
    public boolean isStackValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null && stack.field_77994_a > 0;
    }

    @Override
    @Nonnull
    public ItemStack copyItemStack(@Nullable ItemStack stack) {
        return stack == null ? ItemStackHelper.NULL_STACK : stack.func_77946_l();
    }

    @Override
    @Nonnull
    public CreativeTabs createTab(int index, String label, Supplier<ItemStack> icon) {
        return MCAbstractionInst.createTab_(index, label, icon);
    }

    public Class<MCAbstractedAbstractedItem> getAbstractedItemAbstraction() {
        return MCAbstractedAbstractedItem.class;
    }

    @SubscribeEvent
    public void loadWorld(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            world.func_72848_b((IWorldEventListener)WorldEventListener.INSTANCE);
            world.func_72954_a((IWorldEventListener)WorldEventListener.INSTANCE);
        }
    }

    @Override
    public List<Object> getRecipeOutput(ShapelessOreRecipe shapelessOreRecipe) {
        return shapelessOreRecipe.getInput();
    }

    @Override
    public WidgetSlot wrapSlot(final Slot slot) {
        return new WidgetSlot(null, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f){

            @Override
            public void onSlotChange(ItemStack newStack, ItemStack oldStack) {
                slot.func_75220_a(newStack, oldStack);
            }

            @Override
            public void onCrafting(ItemStack stack, int amount) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onCrafting(ItemStack stack) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onSwapCraft(int slot2) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nonnull
            public ItemStack onTake(EntityPlayer player, @Nonnull ItemStack stack) {
                slot.func_82870_a(player, stack);
                return stack;
            }

            @Override
            public boolean isItemValid(ItemStack stack) {
                return slot.func_75214_a(stack);
            }

            @Override
            public boolean getHasStack() {
                return slot.func_75216_d();
            }

            @Override
            public void putStack(@Nonnull ItemStack stack) {
                slot.func_75215_d(stack);
            }

            @Override
            public void onSlotChanged() {
                slot.func_75218_e();
            }

            @Override
            public int getSlotStackLimit() {
                return slot.func_75219_a();
            }

            @Override
            public int getItemStackLimit(ItemStack stack) {
                return slot.func_178170_b(stack);
            }

            @Override
            @Nullable
            public String getSlotTexture() {
                return slot.func_178171_c();
            }

            @Override
            @Nonnull
            public ItemStack decrStackSize(int amount) {
                return slot.func_75209_a(amount);
            }

            @Override
            public boolean isHere(IInventory inv, int slotIn) {
                return slot.func_75217_a(inv, slotIn);
            }

            @Override
            public boolean canTakeStack(EntityPlayer playerIn) {
                return slot.func_82869_a(playerIn);
            }

            @Override
            public boolean canBeHovered() {
                return slot.func_111238_b();
            }

            @Override
            @Nonnull
            public ResourceLocation getBackgroundLocation() {
                return slot.getBackgroundLocation();
            }

            @Override
            public void setBackgroundLocation(@Nonnull ResourceLocation texture) {
                slot.setBackgroundLocation(texture);
            }

            @Override
            public void setBackgroundName(@Nonnull String name) {
                slot.setBackgroundName(name);
            }

            @Override
            public TextureAtlasSprite getBackgroundSprite() {
                return slot.getBackgroundSprite();
            }

            @Override
            @Nonnull
            public TextureMap getBackgroundMap() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getSlotIndex() {
                return slot.getSlotIndex();
            }

            @Override
            public boolean isSameInventory(WidgetSlot other) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ItemStack getStack() {
                return slot.func_75211_c();
            }

            @Override
            public IItemHandler getInventory() {
                return new InvWrapper(slot.field_75224_c);
            }
        };
    }
}

