/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.net.clientToClientAPI;

import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.net.clientToClientAPI.ClientContext;
import com.mrdimka.hammercore.net.clientToClientAPI.IClientToClientMessage;
import com.mrdimka.hammercore.net.packetAPI.IPacket;
import com.mrdimka.hammercore.net.packetAPI.IPacketListener;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class PacketClientToClient
implements IPacket,
IPacketListener<PacketClientToClient, IPacket> {
    private NBTTagCompound message;
    private UUID[] acceptors;
    private UUID creator;

    public PacketClientToClient() {
    }

    public PacketClientToClient(IClientToClientMessage message, UUID ... acceptors) {
        this.message = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        message.writeToNbt(tag);
        this.message.func_74782_a("data", (NBTBase)tag);
        this.message.func_74778_a("class", message.getClass().getName());
        this.acceptors = acceptors;
    }

    private PacketClientToClient(NBTTagCompound message, UUID creator) {
        this.message = message.func_74737_b();
        this.creator = creator;
    }

    @Override
    public IPacket onArrived(PacketClientToClient packet, MessageContext context) {
        if (context.side == Side.CLIENT) {
            packet.readAndExecute();
        } else {
            UUID[] acceptors = packet.acceptors;
            packet.acceptors = null;
            EntityPlayerMP creator = context.getServerHandler().field_147369_b;
            for (int i = 0; i < acceptors.length; ++i) {
                EntityPlayerMP mp = creator.field_71133_b.func_184103_al().func_177451_a(acceptors[i]);
                HCNetwork.manager.sendTo(new PacketClientToClient(packet.message, creator.func_110124_au()), mp);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void readAndExecute() {
        try {
            Object obj = Class.forName(this.message.func_74779_i("class")).newInstance();
            if (obj instanceof IClientToClientMessage) {
                IClientToClientMessage msg = (IClientToClientMessage)obj;
                msg.readFromNbt(this.message.func_74775_l("data"));
                ClientContext ctx = new ClientContext(this.creator);
                msg.execute(ctx);
            }
        }
        catch (ClassNotFoundException obj) {
        }
        catch (Throwable err) {
            FMLLog.log((String)"Hammer Core", (Level)Level.ERROR, (String)"Failed to execute client-to-client message:", (Object[])new Object[0]);
            err.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList ids = new NBTTagList();
        PacketClientToClient.packUUIDs(ids, this.acceptors);
        nbt.func_74782_a("uids", (NBTBase)ids);
        nbt.func_74782_a("msg", (NBTBase)this.message);
        if (this.creator != null) {
            nbt.func_186854_a("creator", this.creator);
        }
        nbt.func_74757_a("creatorNN", this.creator != null);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.acceptors = PacketClientToClient.unpackUUIDs(nbt.func_150295_c("uids", 10));
        this.message = nbt.func_74775_l("msg");
        if (nbt.func_74767_n("creatorNN")) {
            this.creator = nbt.func_186857_a("creator");
        }
    }

    private static void packUUIDs(NBTTagList list, UUID ... ids) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            list.func_74744_a(i);
        }
        if (ids == null || ids.length == 0) {
            return;
        }
        for (UUID id : ids) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a("id", id);
        }
    }

    private static UUID[] unpackUUIDs(NBTTagList list) {
        if (list.func_74745_c() == 0) {
            return null;
        }
        UUID[] ids = new UUID[list.func_74745_c()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = list.func_150305_b(i).func_186857_a("id");
        }
        return ids;
    }
}

