/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.renderer.item;

import com.mrdimka.hammercore.client.UV;
import com.mrdimka.hammercore.client.renderer.RenderSmoke;
import com.mrdimka.hammercore.client.renderer.item.EnumItemRender;
import com.mrdimka.hammercore.client.renderer.item.IItemRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ItemTorchRender
implements IItemRenderer {
    public static final ResourceLocation particlel = new ResourceLocation("hammercore", "textures/gui/particles.png");
    public static final UV[] SMOKE_UVS = new UV[]{new UV(particlel, 56.0, 0.0, 8.0, 8.0), new UV(particlel, 48.0, 0.0, 8.0, 8.0), new UV(particlel, 40.0, 0.0, 8.0, 8.0), new UV(particlel, 32.0, 0.0, 8.0, 8.0), new UV(particlel, 24.0, 0.0, 8.0, 8.0), new UV(particlel, 16.0, 0.0, 8.0, 8.0), new UV(particlel, 8.0, 0.0, 8.0, 8.0), new UV(particlel, 0.0, 0.0, 8.0, 8.0)};
    public List<RenderSmoke> effects = new ArrayList<RenderSmoke>();
    private long lastAdd = 0L;
    public static final Random rand = new Random();

    @Override
    public boolean handleRenderFor(EnumItemRender render, ItemStack stack) {
        return render == EnumItemRender.GUI && stack != null && (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA));
    }

    @Override
    public void render(EnumItemRender render, ItemStack stack, double x, double y, double z) {
        long currentTimeMS = System.currentTimeMillis() + (long)this.hashCode();
        rand.setSeed(currentTimeMS);
        if (rand.nextInt(100) <= 2 && currentTimeMS - this.lastAdd >= 50L) {
            this.lastAdd = currentTimeMS;
            this.effects.add(new RenderSmoke(750L));
        }
        boolean useColored = false;
        for (RenderSmoke r : this.effects) {
            rand.setSeed(this.hashCode() + r.hashCode() + stack.hashCode());
            if (useColored) {
                GL11.glColor3d((double)rand.nextDouble(), (double)rand.nextDouble(), (double)rand.nextDouble());
            } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa)) {
                double rgb = rand.nextDouble() / 3.0;
                GL11.glColor3d((double)rgb, (double)rgb, (double)rgb);
            } else if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA)) {
                GL11.glColor3d((double)(0.25 + rand.nextDouble() / 1.25), (double)0.1, (double)0.1);
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 1.0 + rand.nextDouble() * 6.0), (double)(y + rand.nextDouble() * 4.0 - 1.0), (double)z);
            r.render();
            GL11.glPopMatrix();
            if (!r.shouldRender()) {
                this.effects.set(this.effects.indexOf(r), null);
            }
            GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        }
        while (this.effects.contains(null)) {
            this.effects.remove(null);
        }
    }
}

