/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.model;

import com.mrdimka.hammercore.client.model.SimpleModelLoader;
import com.mrdimka.hammercore.client.model.file.ModelFile;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum SimpleModelRegistry {
    INSTANCE;

    public final Map<String, ModelBase> modelCache = new HashMap<String, ModelBase>();

    private SimpleModelRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ModelBase getModelByPath(ResourceLocation location) {
        return this.modelCache.get(location + "");
    }

    public ModelBase getModelByPath(String path) {
        return this.modelCache.get(path);
    }

    public void registerModel(String path) {
        this.modelCache.put(path, null);
    }

    public void registerModel(ResourceLocation location) {
        this.modelCache.put(location + "", null);
    }

    @SubscribeEvent
    public void reloadResources(TextureStitchEvent event) {
        this.reloadModels();
    }

    public void reloadModels() {
        String[] cache;
        IResourceManager mgr = Minecraft.func_71410_x().func_110442_L();
        int cycles = 0;
        while (true) {
            try {
                if (cycles++ >= 32) {
                    return;
                }
                cache = this.modelCache.keySet().toArray(new String[0]);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
        for (String k : cache) {
            try {
                InputStream i = mgr.func_110536_a(new ResourceLocation(k)).func_110527_b();
                this.modelCache.put(k, SimpleModelLoader.convert(ModelFile.read(i)));
            }
            catch (Throwable err) {
                FMLLog.info((String)("Model " + k + " could not be loaded:"), (Object[])new Object[0]);
                err.printStackTrace();
            }
        }
    }
}

