/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.containers.ContainerWashingMachine;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageUpdateFields;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityWashingMachine
extends TileEntityLockable
implements ISidedInventory,
ITickable {
    private static final int[] slots_top = new int[]{0, 1, 2, 3};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4};
    private static final int[] slots_sides = new int[]{4};
    private ItemStack[] inventory = new ItemStack[5];
    private boolean washing = false;
    public boolean superMode = false;
    public int progress = 0;
    public int timeRemaining = 0;
    private Random rand = new Random();
    private int timer = 0;

    public void startWashing() {
        if (this.canWash()) {
            if (this.timeRemaining == 0) {
                this.superMode = this.inventory[4].func_77973_b() == FurnitureItems.itemSuperSoapyWater;
                this.inventory[4] = new ItemStack(this.inventory[4].func_77973_b().func_77668_q());
                this.timeRemaining = 5000;
            }
            this.washing = true;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public void stopWashing() {
        this.progress = 0;
        this.washing = false;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
    }

    public boolean canWash() {
        if (this.inventory[4] == null && this.timeRemaining == 0) {
            return false;
        }
        if (this.inventory[4] != null && this.timeRemaining == 0 && this.inventory[4].func_77973_b() != FurnitureItems.itemSoapyWater && this.inventory[4].func_77973_b() != FurnitureItems.itemSuperSoapyWater) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            RecipeData data;
            if (this.inventory[i] == null || (data = RecipeAPI.getWashingMachineRecipeFromInput(this.inventory[i])) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isWashing() {
        return this.washing;
    }

    public static boolean isFuel(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == FurnitureItems.itemSoapyWater) {
            return true;
        }
        return stack.func_77973_b() == FurnitureItems.itemSuperSoapyWater;
    }

    public void func_73660_a() {
        if (this.washing) {
            if (this.field_145850_b.field_72995_K) {
                ++this.progress;
                return;
            }
            if (!this.canWash()) {
                this.washing = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                this.func_70296_d();
                return;
            }
            if (this.canRepair()) {
                for (int i = 0; i < 4; ++i) {
                    if (this.inventory[i] == null || this.inventory[i].func_77958_k() - this.inventory[i].func_77952_i() == this.inventory[i].func_77958_k()) continue;
                    this.inventory[i].func_77964_b(this.inventory[i].func_77952_i() - 1);
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageUpdateFields((IInventory)this, this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                if (this.progress >= 360) {
                    this.progress = 0;
                }
            }
            --this.timeRemaining;
            if (this.timeRemaining <= 0) {
                if (this.inventory[4] != null) {
                    if (this.inventory[4].func_77973_b() == FurnitureItems.itemSoapyWater) {
                        this.superMode = false;
                        this.inventory[4] = new ItemStack(FurnitureItems.itemSoapyWater.func_77668_q());
                        this.timeRemaining = 5000;
                    } else if (this.inventory[4].func_77973_b() == FurnitureItems.itemSuperSoapyWater) {
                        this.superMode = true;
                        this.inventory[4] = new ItemStack(FurnitureItems.itemSuperSoapyWater.func_77668_q());
                        this.timeRemaining = 5000;
                    }
                } else {
                    this.timeRemaining = 0;
                    this.progress = 0;
                    this.washing = false;
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                }
                this.func_70296_d();
            }
            ++this.progress;
            if (this.timer == 20) {
                this.timer = 0;
            }
            if (this.timer == 0) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, FurnitureSounds.washing_machine, SoundCategory.BLOCKS, 0.75f, 1.0f, true);
            }
            ++this.timer;
        }
    }

    public boolean canRepair() {
        return this.progress % (this.superMode ? 20 : 50) == 0;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int number) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= number) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(number);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory[slot];
    }

    public void func_70299_a(int slot, ItemStack par2ItemStack) {
        this.inventory[slot] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("Items")) {
            NBTTagList tagList = (NBTTagList)tagCompound.func_74781_a("Items");
            this.inventory = new ItemStack[6];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                byte slot = nbt.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
        }
        this.washing = tagCompound.func_74767_n("Washing");
        this.superMode = tagCompound.func_74767_n("SuperMode");
        this.progress = tagCompound.func_74762_e("Progress");
        this.timeRemaining = tagCompound.func_74762_e("Remaining");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)slot);
            this.inventory[slot].func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        tagCompound.func_74757_a("Washing", this.washing);
        tagCompound.func_74757_a("SuperMode", this.superMode);
        tagCompound.func_74768_a("Progress", this.progress);
        tagCompound.func_74768_a("Remaining", this.timeRemaining);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return this.timeRemaining;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
            }
            case 1: {
                this.timeRemaining = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public String func_70005_c_() {
        return "Washing Machine";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armour = (ItemArmor)stack.func_77973_b();
            return slot == armour.field_77881_a.func_188454_b();
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return slots_top;
        }
        if (side == EnumFacing.DOWN) {
            return slots_bottom;
        }
        return slots_sides;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        if (this.func_174893_q_()) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return RecipeAPI.getWashingMachineRecipeFromInput(stack) != null;
        }
        if (side != EnumFacing.DOWN) {
            return TileEntityWashingMachine.isFuel(stack);
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && !TileEntityWashingMachine.isFuel(stack) && stack.func_77952_i() == 0 && !this.func_174893_q_();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerWashingMachine((IInventory)playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "0";
    }
}

