/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks.tv;

import com.mrcrayfish.furniture.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Channel {
    private static Map<BlockPos, PositionedSoundRecord> currentSounds = new ConcurrentHashMap<BlockPos, PositionedSoundRecord>();
    private String channelName;
    private TextureAtlasSprite atlas = null;
    private ResourceLocation sound = null;
    private SoundHandler soundHandler = null;
    private Field counterField = null;
    private static boolean init = false;

    public Channel(String channelName) {
        this.channelName = channelName;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.sound = new ResourceLocation("cfm:" + channelName);
            this.soundHandler = Minecraft.func_71410_x().func_147118_V();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initRefleciton() {
        if (init) {
            return;
        }
        if (this.counterField != null) {
            return;
        }
        if (this.atlas == null) {
            this.atlas = Minecraft.func_71410_x().func_147117_R().getTextureExtry("cfm:blocks/" + this.channelName);
        }
        try {
            this.counterField = ReflectionUtil.getField(this.atlas.getClass(), "frameCounter");
            ReflectionUtil.makeAccessible(this.counterField);
        }
        catch (NoSuchFieldException e) {
            System.out.println("Unabled to initialized animation resetting for TV");
        }
        init = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void play(BlockPos pos) {
        this.resetAnimation();
        this.playSound(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void resetAnimation() {
        this.initRefleciton();
        if (this.atlas != null && this.counterField != null) {
            try {
                this.counterField.setInt(this.atlas, 0);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(BlockPos pos) {
        Channel.stopSound(pos);
        PositionedSoundRecord sound = new PositionedSoundRecord(this.sound, SoundCategory.BLOCKS, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, false, 0, null, (float)pos.func_177952_p() + 0.5f, 0.0f, 0.0f);
        currentSounds.put(pos, sound);
        this.soundHandler.func_147682_a((ISound)sound);
    }

    @SideOnly(value=Side.CLIENT)
    private static PositionedSoundRecord getSound(BlockPos soundPos) {
        for (BlockPos currentPos : currentSounds.keySet()) {
            if (!currentPos.equals((Object)soundPos)) continue;
            return currentSounds.get(currentPos);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void stopSound(BlockPos pos) {
        PositionedSoundRecord sound = Channel.getSound(pos);
        if (sound != null) {
            SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
            if (handler.func_147692_c((ISound)sound)) {
                handler.func_147683_b((ISound)sound);
            }
            currentSounds.remove(sound);
        }
    }
}

