/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.DamageSourceFence;
import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.init.FurnitureAchievements;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockElectricFence
extends Block {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private static final AxisAlignedBB COLLISION_BOX_CENTER = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
    private static final AxisAlignedBB COLLISION_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.5625, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    private static final AxisAlignedBB COLLISION_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.5625, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    private static final AxisAlignedBB COLLISION_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.5625, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    private static final AxisAlignedBB COLLISION_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.5625, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    public DamageSource electricFence = new DamageSourceFence("electricFence");

    public BlockElectricFence(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185858_k);
        this.func_149715_a(0.2f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ((EntityPlayer)placer).func_71029_a((StatBase)FurnitureAchievements.modernTechnology);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        return BOUNDING_BOX[BlockElectricFence.getBoundingBoxId(state)];
    }

    private static int getBoundingBoxId(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB axisAligned, List<AxisAlignedBB> axisAlignedList, Entity collidingEntity) {
        if (((Boolean)(state = state.func_185899_b((IBlockAccess)worldIn, pos)).func_177229_b((IProperty)NORTH)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)COLLISION_BOX_NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)COLLISION_BOX_EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)COLLISION_BOX_SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)COLLISION_BOX_WEST);
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)COLLISION_BOX_CENTER);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(entity instanceof EntityItem) && !entity.func_70005_c_().equals("unknown")) {
            if (entity instanceof EntityCreeper) {
                EntityCreeper creeper = (EntityCreeper)entity;
                EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
                if (!creeper.func_70830_n()) {
                    creeper.func_70015_d(1);
                    creeper.func_70077_a(lightning);
                }
            } else if (entity instanceof EntityPlayer) {
                if (!((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                    entity.func_70097_a(this.electricFence, 2.0f);
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, FurnitureSounds.zap, SoundCategory.BLOCKS, 0.2f, 1.0f, false);
                    this.sparkle(world, pos);
                    ((EntityPlayer)entity).func_71029_a((StatBase)FurnitureAchievements.careful);
                }
            } else {
                entity.func_70097_a(this.electricFence, 2.0f);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, FurnitureSounds.zap, SoundCategory.BLOCKS, 0.2f, 1.0f, false);
                this.sparkle(world, pos);
            }
        }
    }

    private void sparkle(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        double d0 = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)pos.func_177958_n() + RANDOM.nextFloat();
            double d2 = (float)pos.func_177956_o() + RANDOM.nextFloat();
            double d3 = (float)pos.func_177952_p() + RANDOM.nextFloat();
            if (l == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_149662_c(state)) {
                d2 = (double)(pos.func_177956_o() + 1) + d0;
            }
            if (l == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().func_149662_c(state)) {
                d2 = (double)(pos.func_177956_o() + 0) - d0;
            }
            if (l == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_177230_c().func_149662_c(state)) {
                d3 = (double)(pos.func_177952_p() + 1) + d0;
            }
            if (l == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_177230_c().func_149662_c(state)) {
                d3 = (double)(pos.func_177952_p() + 0) - d0;
            }
            if (l == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_177230_c().func_149662_c(state)) {
                d1 = (double)(pos.func_177958_n() + 1) + d0;
            }
            if (l == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_177230_c().func_149662_c(state)) {
                d1 = (double)(pos.func_177958_n() + 0) - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.isFence(world, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.isFence(world, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.isFence(world, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.isFence(world, pos.func_177976_e())));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST});
    }

    public boolean isFence(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this;
    }
}

