/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.util.CollisionHelper;
import com.mrcrayfish.furniture.util.SittableUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBench
extends BlockFurniture {
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    private static final AxisAlignedBB BOUNDING_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0625, 0.0, 0.0, 0.9375, 0.625, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0625, 0.0, 0.0, 0.9375, 0.625, 1.0);
    private static final AxisAlignedBB COLLISION_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.125, 0.0, 0.0625, 0.875, 0.5625, 0.9375);
    private static final AxisAlignedBB COLLISION_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.125, 0.0, 0.0625, 0.875, 0.5625, 0.9375);

    public BlockBench(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.func_176201_c(state) % 2 == 1) {
            return BOUNDING_BOX_NORTH;
        }
        return BOUNDING_BOX_EAST;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB axisAligned, List<AxisAlignedBB> axisAlignedList, Entity collidingEntity) {
        if (this.func_176201_c(state) % 2 == 1) {
            BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)COLLISION_BOX_NORTH);
            return;
        }
        BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)axisAligned, axisAlignedList, (AxisAlignedBB)COLLISION_BOX_EAST);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            IBlockState right = worldIn.func_180495_p(pos.func_177974_f());
            IBlockState left = worldIn.func_180495_p(pos.func_177976_e());
            if (worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == this && right.func_177229_b((IProperty)FACING) == EnumFacing.NORTH | right.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                state = state.func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(true));
            }
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == this && left.func_177229_b((IProperty)FACING) == EnumFacing.NORTH | left.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                state = state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
            IBlockState right = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState left = worldIn.func_180495_p(pos.func_177968_d());
            if (right.func_177230_c() == this && right.func_177229_b((IProperty)FACING) == EnumFacing.EAST | right.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
                state = state.func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(true));
            }
            if (left.func_177230_c() == this && left.func_177229_b((IProperty)FACING) == EnumFacing.EAST | left.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
                state = state.func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return state;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.4);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LEFT, RIGHT});
    }
}

